/*
 * Decompiled with CFR 0.152.
 */
package cn.com.kernol.advancedcontroller.proxy;

import cn.com.kernol.advancedcontroller.annotation.AdvancedApi;
import cn.com.kernol.advancedcontroller.annotation.AdvancedController;
import cn.com.kernol.advancedcontroller.aware.ApplicationContextHolder;
import cn.com.kernol.advancedcontroller.exception.NoTargetClassException;
import cn.com.kernol.advancedcontroller.exception.NoTargetMethodException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class AdvancedApiMethod {
    private static final Map<Method, AdvancedApiMethod> cachedApiMethods = new ConcurrentHashMap<Method, AdvancedApiMethod>();
    private static final Map<String, Method> cachedAnnoTargetMethods = new ConcurrentHashMap<String, Method>();
    private Method apiMethod;
    private Class<?> apiInterface;
    private Method targetMethod;
    private String targetMethodName;
    private Class<?> targetClass;
    private String targetQualifier;
    private Object target;

    private AdvancedApiMethod(Method apiMethod, Class<?> apiInterface) {
        this.apiMethod = apiMethod;
        this.apiInterface = apiInterface;
        this.handleTarget();
    }

    static AdvancedApiMethod getApiMethod(Method method, Class<?> apiInterface) {
        return cachedApiMethods.computeIfAbsent(method, m -> new AdvancedApiMethod((Method)m, apiInterface));
    }

    private void handleTarget() {
        String targetMethodName;
        String targetQualifier;
        Class<?> targetClass;
        ApplicationContext context = ApplicationContextHolder.applicationContext;
        AdvancedApi methodAnno = this.apiMethod.getDeclaredAnnotation(AdvancedApi.class);
        AdvancedController classAnno = this.apiInterface.getAnnotation(AdvancedController.class);
        Class<?> clazz = targetClass = classAnno.value().equals(Void.class) ? classAnno.target() : classAnno.value();
        if (methodAnno == null) {
            targetQualifier = classAnno.qualifier();
            targetMethodName = this.apiMethod.getName();
        } else {
            if (methodAnno.target().equals(Void.class)) {
                targetQualifier = classAnno.qualifier();
            } else {
                targetClass = methodAnno.target();
                targetQualifier = methodAnno.qualifier();
            }
            String value = StringUtils.isEmpty((Object)methodAnno.name()) ? methodAnno.value() : methodAnno.name();
            targetMethodName = StringUtils.isEmpty((Object)value) ? this.apiMethod.getName() : value;
        }
        this.targetClass = targetClass;
        this.targetMethodName = targetMethodName;
        this.targetQualifier = targetQualifier;
        this.target = !StringUtils.isEmpty((Object)targetQualifier) ? context.getBean(targetQualifier) : context.getBean(targetClass);
        try {
            this.targetMethod = this.target.getClass().getMethod(targetMethodName, this.apiMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            System.out.println("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76ee\u6807\u65b9\u6cd5");
            throw new NoTargetMethodException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76ee\u6807\u65b9\u6cd5, targetClass:" + targetClass + ";\ntarget:" + this.target.getClass().getName() + ";\ntargetQualifier:" + targetQualifier + ";\ntargetMethodName:" + targetMethodName);
        }
    }

    Object execute(Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (this.targetMethod != null && this.target != null) {
            return this.targetMethod.invoke(this.target, args);
        }
        if (this.target == null) {
            throw new NoTargetClassException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76ee\u6807\u7c7b, targetClass:" + this.targetClass + ";\ntargetQualifier:" + this.targetQualifier + ";\ntargetMethodName:" + this.targetMethodName);
        }
        throw new NoTargetMethodException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u76ee\u6807\u65b9\u6cd5, targetClass:" + this.targetClass + ";\ntarget:" + this.target.getClass().getName() + ";\ntargetQualifier:" + this.targetQualifier + ";\ntargetMethodName:" + this.targetMethodName);
    }
}

