/*
 * Decompiled with CFR 0.152.
 */
package cn.com.kernol.advancedcontroller.proxy;

import cn.com.kernol.advancedcontroller.proxy.AdvancedApiMethod;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ControllerJDKProxy<T>
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ControllerJDKProxy.class);
    private Class<T> controllerInterface;
    private Set<Method> apiMethods;

    public ControllerJDKProxy(Class<T> controllerInterface) {
        this.controllerInterface = controllerInterface;
        this.initMethods();
    }

    public static <T> Object newProxyInstance(Class<T> controllerInterface) {
        ControllerJDKProxy<T> handler = new ControllerJDKProxy<T>(controllerInterface);
        return Proxy.newProxyInstance(controllerInterface.getClassLoader(), new Class[]{controllerInterface}, handler);
    }

    private void initMethods() {
        Assert.notNull(this.controllerInterface, (String)"controller\u63a5\u53e3\u4e0d\u80fd\u4e3anull");
        Method[] methods = this.controllerInterface.getMethods();
        this.apiMethods = new HashSet<Method>();
        if (methods.length > 0) {
            this.apiMethods.addAll(Arrays.asList(methods));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        logger.debug("\u65b9\u6cd5\u8c03\u7528\uff1a" + method.getName());
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        if (this.isDefaultMethod(method)) {
            return this.invokeDefaultMethod(proxy, method, args);
        }
        try {
            return AdvancedApiMethod.getApiMethod(method, this.controllerInterface).execute(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 15)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
    }

    private boolean isDefaultMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
    }
}

