/*
 * Decompiled with CFR 0.152.
 */
package cn.com.kernol.advancedcontroller.register;

import cn.com.kernol.advancedcontroller.annotation.AdvancedController;
import cn.com.kernol.advancedcontroller.proxy.ControllerFactoryBean;
import cn.com.kernol.advancedcontroller.register.ControllerScannerRegistrar;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ControllerClassPathScanner
extends ClassPathBeanDefinitionScanner {
    private Logger logger = LoggerFactory.getLogger(ControllerScannerRegistrar.class);

    public ControllerClassPathScanner(BeanDefinitionRegistry registry, boolean useDefaultFilters) {
        super(registry, useDefaultFilters);
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AdvancedController.class));
        Set beanDefinitionHolders = super.doScan(basePackages);
        if (beanDefinitionHolders.isEmpty()) {
            this.logger.warn("\u5728\u4ee5\u4e0b\u5305\u540d\u4e0b\u6ca1\u6709\u627e\u5230\u6807\u8bb0\u4e3aAdvancedController\u7684\u63a5\u53e3: '" + Arrays.toString(basePackages) + "'.");
        } else {
            this.processBeanDefinitions(beanDefinitionHolders);
        }
        return beanDefinitionHolders;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            this.logger.debug("Creating MapperFactoryBean with name '" + holder.getBeanName() + "' and '" + beanClassName + "' ControllerInterface");
            try {
                Class<?> beanClazz = Class.forName(beanClassName);
                definition.getConstructorArgumentValues().addGenericArgumentValue(beanClazz);
                definition.setBeanClass(ControllerFactoryBean.class);
                definition.setAutowireMode(2);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn("Skipping ControllerFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' ControllerInterface. Bean already defined with the same name!");
        return false;
    }
}

