/*
 * Decompiled with CFR 0.152.
 */
package cn.com.kernol.advancedcontroller.register;

import cn.com.kernol.advancedcontroller.aware.ApplicationContextHolder;
import cn.com.kernol.advancedcontroller.register.ControllerClassPathScanner;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class ControllerScannerConfigurer
implements BeanFactoryAware,
BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ControllerScannerConfigurer.class);
    private String basePackage;
    private BeanFactory beanFactory;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        logger.debug("\u5f00\u59cb\u67e5\u627e @AdvancedController \u6807\u6ce8\u7684\u63a5\u53e3");
        ControllerClassPathScanner scanner = new ControllerClassPathScanner(registry, false);
        Object[] packages = null;
        try {
            if (StringUtils.isEmpty((Object)this.basePackage)) {
                List packageList = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
                packages = StringUtils.toStringArray((Collection)packageList);
            } else {
                packages = StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n");
            }
            scanner.doScan((String[])packages);
        }
        catch (IllegalStateException e) {
            logger.debug("\u67e5\u627e @AdvancedController \u6807\u6ce8\u7684\u63a5\u53e3\u5931\u8d25\uff0c\u5305\u540d\uff1a" + StringUtils.arrayToDelimitedString((Object[])packages, (String)","), (Throwable)e);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHolder.applicationContext = applicationContext;
    }
}

