/*
 * Decompiled with CFR 0.152.
 */
package com.emorym.android_pusher;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.emorym.android_pusher.PusherCallback;
import de.roderick.weberknecht.WebSocketConnection;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketException;
import de.roderick.weberknecht.WebSocketMessage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Pusher {
    private static final String TAG = "Pusher";
    protected static final long WATCHDOG_SLEEP_TIME_MS = 5000L;
    private final String VERSION = "1.8.3";
    private final String HOST = "ws.pusherapp.com";
    private final int WS_PORT = 80;
    private final int WSS_PORT = 443;
    private final String HTTP_PREFIX = "ws://";
    private final String HTTPS_PREFIX = "wss://";
    protected WebSocketConnection mWebSocket = null;
    private final Handler mHandler;
    private Thread mWatchdog;
    protected String mSocketId;
    private String mApplicationkey;
    private boolean mEncrypted;
    private boolean trustAllCerts;
    public final HashMap<String, Channel> channels = new HashMap();
    public final Channel globalChannel = new Channel("pusher_global_channel");

    public Pusher(String application_key, boolean encrypted, boolean trustAllCertificates) {
        this.mApplicationkey = application_key;
        this.mEncrypted = encrypted;
        this.trustAllCerts = trustAllCertificates;
        this.mHandler = new PusherHandler(this);
        this.connect();
    }

    public Pusher(String application_key, boolean encrypted) {
        this(application_key, encrypted, false);
    }

    public Pusher(String application_key) {
        this(application_key, true);
    }

    @Deprecated
    public Pusher(Handler _mHandler, boolean encrypted) {
        this.mHandler = _mHandler;
        this.mEncrypted = encrypted;
    }

    @Deprecated
    public Pusher(Handler _mHandler) {
        this(_mHandler, true);
    }

    public void disconnect() {
        block2: {
            try {
                this.mWatchdog.interrupt();
                this.mWatchdog = null;
                this.mWebSocket.close();
            }
            catch (WebSocketException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block2;
                Log.d((String)TAG, (String)"Exception closing web socket", (Throwable)e);
            }
        }
    }

    public Pusher bind(String event, PusherCallback callback) {
        this.globalChannel.bind(event, callback);
        return this;
    }

    public Pusher bindAll(PusherCallback callback) {
        this.globalChannel.bindAll(callback);
        return this;
    }

    public Pusher unbind(String event) {
        this.globalChannel.unbind(event);
        return this;
    }

    public Channel subscribe(String channelName) {
        Channel c;
        block3: {
            c = new Channel(channelName);
            if (this.mWebSocket != null && this.mWebSocket.isConnected()) {
                try {
                    this.sendSubscribeMessage(c);
                }
                catch (Exception e) {
                    if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                    Log.d((String)TAG, (String)"Exception sending subscribe message", (Throwable)e);
                }
            }
        }
        this.channels.put(channelName, c);
        return c;
    }

    public void unsubscribe(String channelName) {
        if (this.channels.containsKey(channelName)) {
            block4: {
                if (this.mWebSocket != null && this.mWebSocket.isConnected()) {
                    try {
                        this.sendUnsubscribeMessage(this.channels.get(channelName));
                    }
                    catch (Exception e) {
                        if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                        Log.d((String)TAG, (String)"Exception sending unsubscribe message", (Throwable)e);
                    }
                }
            }
            this.channels.remove(channelName);
        }
    }

    private void subscribeToAllChannels() {
        block3: {
            try {
                for (String channelName : this.channels.keySet()) {
                    this.sendSubscribeMessage(this.channels.get(channelName));
                }
            }
            catch (Exception e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                Log.d((String)TAG, (String)"Exception sending subscribe message", (Throwable)e);
            }
        }
    }

    protected String authenticate(String channelName) throws IOException {
        return null;
    }

    private void sendSubscribeMessage(Channel c) throws IOException, JSONException {
        String auth;
        JSONObject data = new JSONObject();
        if (c.name.startsWith("private-") && (auth = this.authenticate(c.name)) != null) {
            data.put("auth", (Object)auth);
        }
        this.send("pusher:subscribe", data, c.name);
    }

    private void sendUnsubscribeMessage(Channel c) {
        JSONObject data = new JSONObject();
        this.send("pusher:unsubscribe", data, c.name);
    }

    public void send(String event_name, JSONObject data, String channel) {
        block5: {
            JSONObject message = new JSONObject();
            try {
                data.put("channel", (Object)channel);
                message.put("event", (Object)event_name);
                message.put("data", (Object)data);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Message: " + message.toString()));
                }
                this.mWebSocket.send(message.toString());
            }
            catch (WebSocketException e) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Exception sending message", (Throwable)e);
                }
            }
            catch (JSONException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block5;
                Log.d((String)TAG, (String)"JSON exception", (Throwable)e);
            }
        }
    }

    public void connect() {
        block5: {
            String prefix = this.mEncrypted ? "wss://" : "ws://";
            int port = this.mEncrypted ? 443 : 80;
            String path = "/app/" + this.mApplicationkey + "?client=js&version=" + "1.8.3";
            try {
                URI url = new URI(prefix + "ws.pusherapp.com" + ":" + port + path);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Connecting to: " + url.toString()));
                }
                this.mWebSocket = new WebSocketConnection(url);
                this.mWebSocket.setTrustAllCerts(this.trustAllCerts);
                this.mWebSocket.setEventHandler(new WebSocketEventHandler(){

                    public void onOpen() {
                        if (Log.isLoggable((String)Pusher.TAG, (int)3)) {
                            Log.d((String)Pusher.TAG, (String)"WebSocket Open");
                        }
                        Pusher.this.subscribeToAllChannels();
                    }

                    public void onMessage(WebSocketMessage message) {
                        block7: {
                            try {
                                JSONObject jsonMessage;
                                String event;
                                if (Log.isLoggable((String)Pusher.TAG, (int)3)) {
                                    Log.d((String)Pusher.TAG, (String)("Message: " + message.getText()));
                                }
                                if ((event = (jsonMessage = new JSONObject(message.getText())).optString("event", null)).equals("pusher:connection_established")) {
                                    JSONObject data = new JSONObject(jsonMessage.getString("data"));
                                    Pusher.this.mSocketId = data.getString("socket_id");
                                    if (Log.isLoggable((String)Pusher.TAG, (int)3)) {
                                        Log.d((String)Pusher.TAG, (String)("Connection Established with Socket Id: " + Pusher.this.mSocketId));
                                    }
                                } else {
                                    Bundle b = new Bundle();
                                    b.putString("event", event);
                                    b.putString("data", jsonMessage.getString("data"));
                                    b.putString("type", "pusher");
                                    b.putString("message", message.getText());
                                    if (jsonMessage.has("channel")) {
                                        b.putString("channel", jsonMessage.getString("channel"));
                                    }
                                    Message msg = new Message();
                                    msg.setData(b);
                                    Pusher.this.mHandler.sendMessage(msg);
                                }
                            }
                            catch (JSONException e) {
                                if (!Log.isLoggable((String)Pusher.TAG, (int)3)) break block7;
                                Log.d((String)Pusher.TAG, (String)"JSON exception", (Throwable)e);
                            }
                        }
                    }

                    public void onClose() {
                        if (Log.isLoggable((String)Pusher.TAG, (int)3)) {
                            Log.d((String)Pusher.TAG, (String)"WebSocket Closed");
                        }
                    }
                });
                this.mWatchdog = new Thread(new Runnable(){

                    public void run() {
                        boolean interrupted = false;
                        while (!interrupted) {
                            try {
                                Thread.sleep(5000L);
                                if (Pusher.this.mWebSocket.isConnected()) continue;
                                Pusher.this.mWebSocket.connect();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            catch (Exception e) {
                                if (!Log.isLoggable((String)Pusher.TAG, (int)3)) continue;
                                Log.d((String)Pusher.TAG, (String)"Exception connecting", (Throwable)e);
                            }
                        }
                    }
                });
                this.mWatchdog.start();
            }
            catch (WebSocketException e) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Web socket exception", (Throwable)e);
                }
            }
            catch (URISyntaxException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block5;
                Log.d((String)TAG, (String)"URI syntax exception", (Throwable)e);
            }
        }
    }

    @Deprecated
    public void connect(String application_key, boolean encrypted) {
        this.mApplicationkey = application_key;
        this.mEncrypted = encrypted;
        this.connect();
    }

    @Deprecated
    public void connect(String application_key) {
        this.connect(application_key, true);
    }

    private class PusherHandler
    extends Handler {
        Pusher pusher;

        public PusherHandler(Pusher pusher2) {
            this.pusher = pusher2;
        }

        public void handleMessage(Message msg) {
            block4: {
                if (Log.isLoggable((String)Pusher.TAG, (int)3)) {
                    Log.d((String)Pusher.TAG, (String)("Message handled: " + msg.getData().toString()));
                }
                try {
                    String channelName;
                    String eventName = msg.getData().getString("event");
                    JSONObject eventData = new JSONObject(msg.getData().getString("data"));
                    this.pusher.globalChannel.dispatch(eventName, eventData);
                    if (msg.getData().containsKey("channel") && this.pusher.channels.containsKey(channelName = msg.getData().getString("channel"))) {
                        Channel channel = this.pusher.channels.get(channelName);
                        channel.dispatch(eventName, eventData);
                    }
                }
                catch (JSONException e) {
                    if (!Log.isLoggable((String)Pusher.TAG, (int)3)) break block4;
                    Log.d((String)Pusher.TAG, (String)"JSON exception", (Throwable)e);
                }
            }
        }
    }

    public class Channel {
        public final String name;
        public final HashMap<String, List<PusherCallback>> callbacks = new HashMap();
        public final List<PusherCallback> globalCallbacks = new ArrayList<PusherCallback>();

        public Channel(String _name) {
            this.name = _name;
        }

        public Channel bind(String event, PusherCallback callback) {
            if (!this.callbacks.containsKey(event)) {
                this.callbacks.put(event, new ArrayList());
            }
            this.callbacks.get(event).add(callback);
            return this;
        }

        public Channel bindAll(PusherCallback callback) {
            this.globalCallbacks.add(callback);
            return this;
        }

        public Channel unbind(String event) {
            if (this.callbacks.containsKey(event)) {
                this.callbacks.remove(event);
            }
            return this;
        }

        public void dispatch(String eventName, JSONObject eventData) {
            for (PusherCallback callback : this.globalCallbacks) {
                callback.onEvent(eventName, eventData);
            }
            if (this.callbacks.containsKey(eventName)) {
                for (PusherCallback callback : this.callbacks.get(eventName)) {
                    callback.onEvent(eventData);
                }
            }
        }
    }
}

