/*
 * Decompiled with CFR 0.152.
 */
package de.roderick.weberknecht;

import de.roderick.weberknecht.WebSocketConnection;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class WebSocketReceiver
extends Thread {
    private InputStream input = null;
    private WebSocketConnection websocket = null;
    private WebSocketEventHandler eventHandler = null;
    private volatile boolean stop = false;

    public WebSocketReceiver(InputStream input, WebSocketConnection websocket) {
        this.input = input;
        this.websocket = websocket;
        this.eventHandler = websocket.getEventHandler();
    }

    public void run() {
        boolean frameStart = false;
        ArrayList<Byte> messageBytes = new ArrayList<Byte>();
        while (!this.stop) {
            try {
                int b = this.input.read();
                if (b == 0) {
                    frameStart = true;
                    continue;
                }
                if (b == 255 && frameStart) {
                    frameStart = false;
                    Byte[] message = messageBytes.toArray(new Byte[messageBytes.size()]);
                    this.eventHandler.onMessage(new WebSocketMessage(message));
                    messageBytes.clear();
                    continue;
                }
                if (frameStart) {
                    messageBytes.add((byte)b);
                    continue;
                }
                if (b != -1) continue;
                this.handleError();
            }
            catch (IOException ioe) {
                this.handleError();
            }
        }
    }

    public void stopit() {
        this.stop = true;
    }

    public boolean isRunning() {
        return !this.stop;
    }

    private void handleError() {
        this.stopit();
        this.websocket.handleReceiverError();
    }
}

