/*
 * Decompiled with CFR 0.152.
 */
package com.github.kevinsawicki.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_DATE = "Date";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String PARAM_CHARSET = "charset";
    private static final String BOUNDARY = "00content0boundary00";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data; boundary=00content0boundary00";
    private static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    private final HttpURLConnection connection;
    private RequestOutputStream output;
    private boolean multipart;
    private boolean form;
    private int bufferSize = 8192;

    public static HttpRequest get(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_GET);
    }

    public static HttpRequest get(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_GET);
    }

    public static HttpRequest post(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_POST);
    }

    public static HttpRequest post(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_POST);
    }

    public static HttpRequest put(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_PUT);
    }

    public static HttpRequest put(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_PUT);
    }

    public static HttpRequest delete(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_DELETE);
    }

    public static HttpRequest delete(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_DELETE);
    }

    public static HttpRequest head(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_HEAD);
    }

    public static HttpRequest head(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_HEAD);
    }

    public static HttpRequest options(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_OPTIONS);
    }

    public static HttpRequest options(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_OPTIONS);
    }

    public static HttpRequest trace(String url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_TRACE);
    }

    public static HttpRequest trace(URL url) throws HttpRequestException {
        return new HttpRequest(url, METHOD_TRACE);
    }

    public static void keepAlive(boolean keepAlive) {
        System.setProperty("http.keepAlive", Boolean.toString(keepAlive));
    }

    public HttpRequest(String url, String method) throws HttpRequestException {
        try {
            this.connection = (HttpURLConnection)new URL(url).openConnection();
            this.connection.setRequestMethod(method);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public HttpRequest(URL url, String method) throws HttpRequestException {
        try {
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod(method);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public String toString() {
        return this.connection.getRequestMethod() + " " + this.connection.getURL();
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public int code() throws HttpRequestException {
        try {
            this.closeOutput();
            return this.connection.getResponseCode();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public boolean ok() throws HttpRequestException {
        return 200 == this.code();
    }

    public boolean created() throws HttpRequestException {
        return 201 == this.code();
    }

    public boolean serverError() throws HttpRequestException {
        return 500 == this.code();
    }

    public boolean badRequest() throws HttpRequestException {
        return 400 == this.code();
    }

    public boolean notFound() throws HttpRequestException {
        return 404 == this.code();
    }

    public boolean notModified() throws HttpRequestException {
        return 304 == this.code();
    }

    public String message() throws HttpRequestException {
        try {
            this.closeOutput();
            return this.connection.getResponseMessage();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public HttpRequest disconnect() {
        this.connection.disconnect();
        return this;
    }

    public HttpRequest chunk(int size) {
        this.connection.setChunkedStreamingMode(size);
        return this;
    }

    public HttpRequest bufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.bufferSize = size;
        return this;
    }

    protected ByteArrayOutputStream byteStream() {
        int size = this.contentLength();
        if (size > 0) {
            return new ByteArrayOutputStream(size);
        }
        return new ByteArrayOutputStream();
    }

    public String body(String charset) throws HttpRequestException {
        ByteArrayOutputStream output = this.byteStream();
        this.copy(this.buffer(), output);
        if (charset != null) {
            try {
                return output.toString(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpRequestException(e);
            }
        }
        return output.toString();
    }

    public String body() throws HttpRequestException {
        return this.body(this.charset());
    }

    public byte[] bytes() throws HttpRequestException {
        ByteArrayOutputStream output = this.byteStream();
        this.copy(this.buffer(), output);
        return output.toByteArray();
    }

    public BufferedInputStream buffer() throws HttpRequestException {
        return new BufferedInputStream(this.stream(), this.bufferSize);
    }

    public InputStream stream() throws HttpRequestException {
        if (this.code() < 400) {
            try {
                return this.connection.getInputStream();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
        InputStream stream = this.connection.getErrorStream();
        if (stream != null) {
            return stream;
        }
        try {
            return this.connection.getInputStream();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
    }

    public InputStreamReader reader(String charset) throws HttpRequestException {
        InputStream stream = this.stream();
        if (charset != null) {
            try {
                return new InputStreamReader(stream, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpRequestException(e);
            }
        }
        return new InputStreamReader(stream);
    }

    public InputStreamReader reader() throws HttpRequestException {
        return this.reader(this.charset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest receive(File file) {
        BufferedOutputStream output;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new HttpRequestException(e);
        }
        try {
            HttpRequest httpRequest = this.receive(output);
            return httpRequest;
        }
        finally {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
    }

    public HttpRequest receive(OutputStream output) {
        return this.copy(this.buffer(), output);
    }

    public HttpRequest receive(Appendable appendable) throws HttpRequestException {
        BufferedReader reader = new BufferedReader(this.reader());
        CharBuffer buffer = CharBuffer.allocate(this.bufferSize);
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                buffer.rewind();
                appendable.append(buffer, 0, read);
                buffer.rewind();
            }
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
        return this;
    }

    public HttpRequest receive(Writer writer) throws HttpRequestException {
        BufferedReader reader = new BufferedReader(this.reader());
        return this.copy(reader, writer);
    }

    public HttpRequest readTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
        return this;
    }

    public HttpRequest connectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
        return this;
    }

    public HttpRequest header(String name, String value) {
        this.connection.setRequestProperty(name, value);
        return this;
    }

    public HttpRequest header(String name, Number value) {
        return this.header(name, value != null ? value.toString() : null);
    }

    public HttpRequest headers(String ... headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Headers cannot be null");
        }
        int length = headers.length;
        if (length == 0) {
            throw new IllegalArgumentException("Headers cannot be empty");
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Headers length must be divisible by two");
        }
        for (int i = 0; i < length; i += 2) {
            this.header(headers[i], headers[i + 1]);
        }
        return this;
    }

    public String header(String name) {
        return this.connection.getHeaderField(name);
    }

    public long dateHeader(String name) {
        return this.connection.getHeaderFieldDate(name, -1L);
    }

    public int intHeader(String name) {
        return this.connection.getHeaderFieldInt(name, -1);
    }

    protected String getParam(String value, String paramName) {
        String[] params;
        if (value == null || value.length() == 0) {
            return null;
        }
        int postSemi = value.indexOf(59) + 1;
        if (postSemi == 0 || postSemi == value.length()) {
            return null;
        }
        for (String param : params = value.substring(postSemi).split(";")) {
            String charset;
            int length;
            String[] split = param.split("=");
            if (split.length != 2 || !paramName.equals(split[0].trim()) || (length = (charset = split[1].trim()).length()) == 0) continue;
            if (length > 2 && '\"' == charset.charAt(0) && '\"' == charset.charAt(length - 1)) {
                charset = charset.substring(1, length - 1);
            }
            return charset;
        }
        return null;
    }

    public String charset() {
        return this.getParam(this.contentType(), PARAM_CHARSET);
    }

    public HttpRequest userAgent(String value) {
        return this.header(HEADER_USER_AGENT, value);
    }

    public HttpRequest acceptEncoding(String value) {
        return this.header(HEADER_ACCEPT_ENCODING, value);
    }

    public HttpRequest acceptCharset(String value) {
        return this.header(HEADER_ACCEPT_CHARSET, value);
    }

    public String contentEncoding() {
        return this.header(HEADER_CONTENT_ENCODING);
    }

    public String server() {
        return this.header(HEADER_SERVER);
    }

    public long date() {
        return this.dateHeader(HEADER_DATE);
    }

    public String cacheControl() {
        return this.header(HEADER_CACHE_CONTROL);
    }

    public String eTag() {
        return this.header(HEADER_ETAG);
    }

    public long expires() {
        return this.dateHeader(HEADER_EXPIRES);
    }

    public long lastModified() {
        return this.dateHeader(HEADER_LAST_MODIFIED);
    }

    public String location() {
        return this.header(HEADER_LOCATION);
    }

    public HttpRequest authorization(String value) {
        return this.header(HEADER_AUTHORIZATION, value);
    }

    public HttpRequest basic(String name, String password) {
        return this.authorization("Basic " + Base64.encode(name + ":" + password));
    }

    public HttpRequest ifModifiedSince(long value) {
        this.connection.setIfModifiedSince(value);
        return this;
    }

    public HttpRequest ifNoneMatch(String value) {
        return this.header(HEADER_IF_NONE_MATCH, value);
    }

    public HttpRequest contentType(String value) {
        return this.contentType(value, null);
    }

    public HttpRequest contentType(String value, String charset) {
        if (charset != null) {
            String separator = "; charset=";
            return this.header(HEADER_CONTENT_TYPE, value + "; charset=" + charset);
        }
        return this.header(HEADER_CONTENT_TYPE, value);
    }

    public String contentType() {
        return this.header(HEADER_CONTENT_TYPE);
    }

    public int contentLength() {
        return this.intHeader(HEADER_CONTENT_LENGTH);
    }

    public HttpRequest contentLength(String value) {
        return this.contentLength(Integer.parseInt(value));
    }

    public HttpRequest contentLength(int value) {
        this.connection.setFixedLengthStreamingMode(value);
        return this;
    }

    public HttpRequest accept(String value) {
        return this.header(HEADER_ACCEPT, value);
    }

    protected HttpRequest copy(InputStream input, OutputStream output) throws HttpRequestException {
        byte[] buffer = new byte[this.bufferSize];
        try {
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
        return this;
    }

    protected HttpRequest copy(Reader input, Writer output) throws HttpRequestException {
        char[] buffer = new char[this.bufferSize];
        try {
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
        return this;
    }

    protected HttpRequest closeOutput() throws IOException {
        if (this.output == null) {
            return this;
        }
        if (this.multipart) {
            this.output.write("\r\n--00content0boundary00--\r\n");
        }
        this.output.close();
        this.output = null;
        return this;
    }

    protected HttpRequest openOutput() throws IOException {
        if (this.output != null) {
            return this;
        }
        this.connection.setDoOutput(true);
        String charset = this.getParam(this.connection.getRequestProperty(HEADER_CONTENT_TYPE), PARAM_CHARSET);
        this.output = new RequestOutputStream(this.connection.getOutputStream(), charset, this.bufferSize);
        return this;
    }

    protected HttpRequest startPart() throws IOException {
        if (!this.multipart) {
            this.multipart = true;
            this.contentType(CONTENT_TYPE_MULTIPART).openOutput();
            this.output.write("--00content0boundary00\r\n");
        } else {
            this.output.write("\r\n--00content0boundary00\r\n");
        }
        return this;
    }

    protected HttpRequest writePartHeader(String name, String filename) throws IOException {
        StringBuilder partBuffer = new StringBuilder();
        partBuffer.append("form-data; name=\"").append(name);
        if (filename != null) {
            partBuffer.append("\"; filename=\"").append(filename);
        }
        partBuffer.append('\"');
        return this.partHeader("Content-Disposition", partBuffer.toString());
    }

    public HttpRequest part(String name, String part) {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, String part) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename);
            this.output.write(part);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest part(String name, Number part) throws HttpRequestException {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, Number part) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename);
            this.output.write(part.toString());
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest part(String name, File part) throws HttpRequestException {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, File part) throws HttpRequestException {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(part));
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this.part(name, filename, stream);
    }

    public HttpRequest part(String name, InputStream part) throws HttpRequestException {
        return this.part(name, null, part);
    }

    public HttpRequest part(String name, String filename, InputStream part) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename);
            this.copy(part, this.output);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest partHeader(String name, String value) throws HttpRequestException {
        return this.send(name).send(": ").send(value).send("\r\n\r\n");
    }

    public HttpRequest send(File input) throws HttpRequestException {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(input));
        }
        catch (FileNotFoundException e) {
            throw new HttpRequestException(e);
        }
        return this.send(stream);
    }

    public HttpRequest send(byte[] input) throws HttpRequestException {
        return this.send(new ByteArrayInputStream(input));
    }

    public HttpRequest send(InputStream input) throws HttpRequestException {
        try {
            this.openOutput();
            this.copy(input, this.output);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest send(Reader input) throws HttpRequestException {
        try {
            this.openOutput();
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.output, this.output.charset);
        try {
            this.copy(input, writer);
        }
        finally {
            try {
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new HttpRequestException(e);
            }
        }
        return this;
    }

    public HttpRequest send(String value) throws HttpRequestException {
        try {
            this.openOutput();
            this.output.write(value);
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest form(Map<?, ?> values) throws HttpRequestException {
        return this.form(values, CHARSET_UTF8);
    }

    public HttpRequest form(Object name, Object value) {
        return this.form(name, value, CHARSET_UTF8);
    }

    public HttpRequest form(Object name, Object value, String charset) {
        return this.form(Collections.singletonMap(name, value), charset);
    }

    public HttpRequest form(Map<?, ?> values, String charset) throws HttpRequestException {
        if (!this.form) {
            this.contentType(CONTENT_TYPE_FORM, charset);
            this.form = true;
        }
        if (values.isEmpty()) {
            return this;
        }
        Set<Map.Entry<?, ?>> set = values.entrySet();
        Iterator<Map.Entry<?, ?>> entries = set.iterator();
        try {
            this.openOutput();
            Map.Entry<?, ?> entry = entries.next();
            this.output.write(URLEncoder.encode(entry.getKey().toString(), charset));
            this.output.write(61);
            Object value = entry.getValue();
            if (value != null) {
                this.output.write(URLEncoder.encode(value.toString(), charset));
            }
            while (entries.hasNext()) {
                entry = entries.next();
                this.output.write(38);
                this.output.write(URLEncoder.encode(entry.getKey().toString(), charset));
                this.output.write(61);
                value = entry.getValue();
                if (value == null) continue;
                this.output.write(URLEncoder.encode(value.toString(), charset));
            }
        }
        catch (IOException e) {
            throw new HttpRequestException(e);
        }
        return this;
    }

    public HttpRequest trustAllCerts() throws HttpRequestException {
        SSLContext context;
        if (!(this.connection instanceof HttpsURLConnection)) {
            return this;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, trustAllCerts, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            throw new HttpRequestException(new IOException(e.getLocalizedMessage()));
        }
        ((HttpsURLConnection)this.connection).setSSLSocketFactory(context.getSocketFactory());
        return this;
    }

    public HttpRequest trustAllHosts() {
        if (!(this.connection instanceof HttpsURLConnection)) {
            return this;
        }
        ((HttpsURLConnection)this.connection).setHostnameVerifier(new HostnameVerifier(){

            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        return this;
    }

    public static class RequestOutputStream
    extends BufferedOutputStream {
        private final Charset charset;

        public RequestOutputStream(OutputStream stream, String charsetName, int bufferSize) {
            super(stream, bufferSize);
            if (charsetName == null) {
                charsetName = HttpRequest.CHARSET_UTF8;
            }
            this.charset = Charset.forName(charsetName);
        }

        public RequestOutputStream write(String value) throws IOException {
            super.write(value.getBytes(this.charset));
            return this;
        }
    }

    public static class HttpRequestException
    extends RuntimeException {
        private static final long serialVersionUID = -1170466989781746231L;

        protected HttpRequestException(IOException cause) {
            super(cause);
        }

        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }

    public static class Base64 {
        private static final byte EQUALS_SIGN = 61;
        private static final String PREFERRED_ENCODING = "US-ASCII";
        private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

        private Base64() {
        }

        private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
            byte[] ALPHABET = _STANDARD_ALPHABET;
            int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
            switch (numSigBytes) {
                case 3: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                    return destination;
                }
                case 2: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                    destination[destOffset + 3] = 61;
                    return destination;
                }
                case 1: {
                    destination[destOffset] = ALPHABET[inBuff >>> 18];
                    destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                    destination[destOffset + 2] = 61;
                    destination[destOffset + 3] = 61;
                    return destination;
                }
            }
            return destination;
        }

        public static String encode(String string) {
            byte[] bytes;
            try {
                bytes = string.getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                bytes = string.getBytes();
            }
            return Base64.encodeBytes(bytes);
        }

        public static String encodeBytes(byte[] source) {
            return Base64.encodeBytes(source, 0, source.length);
        }

        public static String encodeBytes(byte[] source, int off, int len) {
            byte[] encoded = Base64.encodeBytesToBytes(source, off, len);
            try {
                return new String(encoded, PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uue) {
                return new String(encoded);
            }
        }

        public static byte[] encodeBytesToBytes(byte[] source, int off, int len) {
            if (source == null) {
                throw new NullPointerException("Cannot serialize a null array.");
            }
            if (off < 0) {
                throw new IllegalArgumentException("Cannot have negative offset: " + off);
            }
            if (len < 0) {
                throw new IllegalArgumentException("Cannot have length offset: " + len);
            }
            if (off + len > source.length) {
                throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", off, len, source.length));
            }
            int encLen = len / 3 * 4 + (len % 3 > 0 ? 4 : 0);
            byte[] outBuff = new byte[encLen];
            int d = 0;
            int e = 0;
            int len2 = len - 2;
            while (d < len2) {
                Base64.encode3to4(source, d + off, 3, outBuff, e);
                d += 3;
                e += 4;
            }
            if (d < len) {
                Base64.encode3to4(source, d + off, len - d, outBuff, e);
                e += 4;
            }
            if (e <= outBuff.length - 1) {
                byte[] finalOut = new byte[e];
                System.arraycopy(outBuff, 0, finalOut, 0, e);
                return finalOut;
            }
            return outBuff;
        }
    }
}

