/*
 * Decompiled with CFR 0.152.
 */
package com.kezong.fataar;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import kotlin.io.FilesKt;
import org.gradle.api.Project;

public class RClassesTransform
extends Transform {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private final ExecutorService executor = Executors.newFixedThreadPool(CPU_COUNT + 1);
    private final List<Future<?>> futures = new ArrayList();
    private final Project project;
    private final Map<String, String> targetPackageMap = new HashMap<String, String>();
    private final Map<String, Collection<String>> libraryPackageMap = new HashMap<String, Collection<String>>();

    public RClassesTransform(Project project) {
        this.project = project;
    }

    public void putTargetPackage(String variantName, String targetPackage) {
        this.targetPackageMap.put(variantName, targetPackage);
    }

    public void putLibraryPackages(String variantName, Collection<String> libraryPackages) {
        this.libraryPackageMap.put(variantName, libraryPackages);
    }

    public String getName() {
        return "transformR";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws InterruptedException, IOException {
        long startTime = System.currentTimeMillis();
        Map<String, String> transformTable = this.buildTransformTable(transformInvocation.getContext().getVariantName());
        boolean isIncremental = transformInvocation.isIncremental() && this.isIncremental();
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        File outputDir = outputProvider.getContentLocation("classes", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
        try {
            for (TransformInput input : transformInvocation.getInputs()) {
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    File directoryFile = directoryInput.getFile();
                    ClassPool classPool = new ClassPool();
                    classPool.insertClassPath(directoryFile.getAbsolutePath());
                    for (File originalClassFile : this.getChangedClassesList(directoryInput)) {
                        if (!originalClassFile.getPath().endsWith(".class")) continue;
                        Future<?> submit = this.executor.submit(() -> {
                            try {
                                File relative = FilesKt.relativeTo((File)originalClassFile, (File)directoryFile);
                                String className = this.filePathToClassname(relative);
                                CtClass ctClass = classPool.get(className);
                                if (transformTable != null) {
                                    ClassFile classFile = ctClass.getClassFile();
                                    ConstPool constPool = classFile.getConstPool();
                                    constPool.renameClass(transformTable);
                                }
                                ctClass.writeFile(outputDir.getAbsolutePath());
                            }
                            catch (IOException | CannotCompileException | NotFoundException e) {
                                e.printStackTrace();
                            }
                        });
                        this.futures.add(submit);
                    }
                }
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.futures.clear();
        long endTime = System.currentTimeMillis();
        this.project.getLogger().info("the task cost " + (endTime - startTime) + "ms");
    }

    private Map<String, String> buildTransformTable(String variantName) {
        String targetPackage = this.targetPackageMap.get(variantName);
        Collection<String> libraryPackages = this.libraryPackageMap.get(variantName);
        if (targetPackage == null || libraryPackages == null) {
            return null;
        }
        List<String> resourceTypes = Arrays.asList("anim", "animator", "array", "attr", "bool", "color", "dimen", "drawable", "font", "fraction", "id", "integer", "interpolator", "layout", "menu", "mipmap", "plurals", "raw", "string", "style", "styleable", "transition", "xml");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String resource : resourceTypes) {
            String targetClass = this.targetPackageMap.get(variantName).replace(".", "/") + "/R$" + resource;
            for (String libraryPackage : this.libraryPackageMap.get(variantName)) {
                String fromClass = libraryPackage.replace(".", "/") + "/R$" + resource;
                map.put(fromClass, targetClass);
            }
        }
        return map;
    }

    private List<File> getChangedClassesList(DirectoryInput directoryInput) throws IOException {
        Map changedFiles = directoryInput.getChangedFiles();
        if (changedFiles.isEmpty()) {
            return Files.walk(directoryInput.getFile().toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
        }
        changedFiles.entrySet().stream().filter(it -> it.getValue() == Status.REMOVED).forEach(it -> ((File)it.getKey()).delete());
        return changedFiles.entrySet().stream().filter(it -> it.getValue() == Status.ADDED || it.getValue() == Status.CHANGED).map(Map.Entry::getKey).filter(File::isFile).collect(Collectors.toList());
    }

    private String filePathToClassname(File file) {
        return file.getPath().replace(".class", "").replace("/", ".").replace("\\", ".");
    }
}

