/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs;

import com.github.klieber.phantomjs.PhantomJSArchive;
import com.github.klieber.phantomjs.PhantomJSArchiveBuilder;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="install", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES)
public class InstallPhantomJsMojo
extends AbstractMojo {
    @Parameter(property="phantomjs.version", required=true)
    private String version;
    @Parameter(defaultValue="https://phantomjs.googlecode.com/files/", property="phantomjs.baseUrl", required=true)
    private String baseUrl;
    @Parameter(defaultValue="${project.build.directory}/phantomjs-maven-plugin", property="phantomjs.outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="phantomjs.binary", property="phantomjs.propertyName", required=true)
    private String propertyName;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("unable to create directory: " + this.outputDirectory);
        }
        PhantomJSArchive phantomJSFile = new PhantomJSArchiveBuilder(this.version).build();
        File extractTo = new File(this.outputDirectory, phantomJSFile.getExtractToPath());
        if (!extractTo.exists()) {
            StringBuilder url = new StringBuilder();
            url.append(this.baseUrl);
            url.append(phantomJSFile.getArchiveName());
            try {
                URL downloadLocation = new URL(url.toString());
                this.getLog().info((CharSequence)("Downloading phantomjs binaries from " + url));
                ReadableByteChannel rbc = Channels.newChannel(downloadLocation.openStream());
                File outputFile = new File(this.outputDirectory, phantomJSFile.getArchiveName());
                FileOutputStream fos = new FileOutputStream(outputFile);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                TFile archive = new TFile(this.outputDirectory, phantomJSFile.getPathToExecutable());
                this.getLog().info((CharSequence)("Extracting " + archive.getAbsolutePath() + " to " + extractTo.getAbsolutePath()));
                extractTo.getParentFile().mkdirs();
                archive.cp(extractTo);
                extractTo.setExecutable(true);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to download phantomjs binary from " + url, (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to download phantomjs binary from " + url, (Exception)e);
            }
        }
        this.mavenProject.getProperties().put(this.propertyName, extractTo.getAbsolutePath());
    }
}

