/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs;

import com.github.klieber.phantomjs.LinuxPhantomJSArchive;
import com.github.klieber.phantomjs.MacOSXPhantomJSArchive;
import com.github.klieber.phantomjs.PhantomJSArchive;
import com.github.klieber.phantomjs.WindowsPhantomJSArchive;

public class PhantomJSArchiveBuilder {
    private final String platform;
    private final String arch;
    private final String version;

    public PhantomJSArchiveBuilder(String platform, String arch, String version) {
        this.platform = platform;
        this.arch = arch;
        this.version = version;
    }

    public PhantomJSArchiveBuilder(String version) {
        this(System.getProperty("os.name").toLowerCase(), System.getProperty("os.arch").toLowerCase(), version);
    }

    public PhantomJSArchive build() {
        PhantomJSArchive archive = null;
        if (this.platform.contains("win")) {
            archive = new WindowsPhantomJSArchive(this.version);
        } else if (this.platform.contains("mac")) {
            archive = new MacOSXPhantomJSArchive(this.version);
        } else if (this.platform.contains("nux")) {
            String modifier = this.arch.contains("64") ? "x86_64" : "i686";
            archive = new LinuxPhantomJSArchive(this.version, modifier);
        }
        if (archive == null) {
            throw new IllegalArgumentException("unknown platform: " + this.platform);
        }
        return archive;
    }
}

