/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.mojo;

import com.github.klieber.phantomjs.mojo.AbstractPhantomJsMojo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

@Mojo(name="exec", defaultPhase=LifecyclePhase.TEST)
public class ExecPhantomJsMojo
extends AbstractPhantomJsMojo {
    @Parameter(property="phantomjs.commandLineOptions")
    private String commandLineOptions;
    @Parameter(property="phantomjs.script")
    private String script;
    @Parameter(property="phantomjs.args")
    private List<String> arguments;
    @Parameter(property="phantomjs.configFile")
    private File configFile;

    @Override
    public void run() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Executing phantomjs command");
        String binary = this.getPhantomJsBinary();
        Commandline commandline = new Commandline(binary);
        if (this.configFile != null && this.configFile.exists()) {
            commandline.createArg().setValue("--config=" + this.configFile.getAbsolutePath());
        } else {
            commandline.addArguments(this.getCommandLineOptions());
        }
        commandline.createArg().setValue(this.script);
        commandline.addArguments(this.arguments.toArray(new String[this.arguments.size()]));
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("phantomjs command: " + Arrays.asList(commandline.getShellCommandline())));
            }
            Process process = new ProcessBuilder(commandline.getShellCommandline()).start();
            ExecPhantomJsMojo.inheritIO(process.getInputStream(), System.out);
            ExecPhantomJsMojo.inheritIO(process.getErrorStream(), System.err);
            process.waitFor();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute phantomjs command", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Failed to execute phantomjs command", (Exception)e);
        }
    }

    private String[] getCommandLineOptions() throws MojoExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)this.commandLineOptions);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute phantomjs command", e);
        }
    }

    private static void inheritIO(final InputStream src, final PrintStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    dest.println(sc.nextLine());
                }
            }
        }).start();
    }
}

