/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.mojo;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.archive.PhantomJSArchiveBuilder;
import com.github.klieber.phantomjs.mojo.AbstractPhantomJsMojo;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.cli.Commandline;

@Mojo(name="install", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES)
public class InstallPhantomJsMojo
extends AbstractPhantomJsMojo {
    private static final String PHANTOMJS = "phantomjs";
    @Parameter(property="phantomjs.version", required=true)
    private String version;
    @Parameter(defaultValue="https://phantomjs.googlecode.com/files/", property="phantomjs.baseUrl", required=true)
    private String baseUrl;
    @Parameter(defaultValue="${project.build.directory}/phantomjs-maven-plugin", property="phantomjs.outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", property="phantomjs.checkSystemPath", required=true)
    private boolean checkSystemPath;
    @Parameter(defaultValue="true", property="phantomjs.enforceVersion", required=true)
    private boolean enforceVersion;

    @Override
    public void run() throws MojoExecutionException {
        String phantomJsBinary = null;
        if (this.checkSystemPath) {
            phantomJsBinary = this.findBinaryOnSystemPath();
        }
        if (phantomJsBinary == null) {
            phantomJsBinary = this.installBinaryFromWeb();
        }
        if (phantomJsBinary != null) {
            this.setPhantomJsBinary(phantomJsBinary);
        }
    }

    private String findBinaryOnSystemPath() throws MojoExecutionException {
        Commandline commandline = new Commandline(PHANTOMJS);
        commandline.createArg().setValue("-v");
        try {
            Process process = new ProcessBuilder(commandline.getShellCommandline()).start();
            BufferedReader standardOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String versionString = standardOut.readLine().trim();
            int exitCode = process.waitFor();
            if (exitCode == 0 && (!this.enforceVersion || this.version.equals(versionString))) {
                this.getLog().info((CharSequence)("Found phantomjs " + versionString + " on the system path."));
                return PHANTOMJS;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check system path", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Failed to check system path", (Exception)e);
        }
        return null;
    }

    private String installBinaryFromWeb() throws MojoExecutionException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Unable to create directory: " + this.outputDirectory);
        }
        PhantomJSArchive phantomJSFile = new PhantomJSArchiveBuilder(this.version).build();
        File extractTo = new File(this.outputDirectory, phantomJSFile.getExtractToPath());
        if (!extractTo.exists()) {
            StringBuilder url = new StringBuilder();
            url.append(this.baseUrl);
            url.append(phantomJSFile.getArchiveName());
            try {
                URL downloadLocation = new URL(url.toString());
                this.getLog().info((CharSequence)("Downloading phantomjs binaries from " + url));
                ReadableByteChannel rbc = Channels.newChannel(downloadLocation.openStream());
                File outputFile = new File(this.outputDirectory, phantomJSFile.getArchiveName());
                FileOutputStream fos = new FileOutputStream(outputFile);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                TFile archive = new TFile(this.outputDirectory, phantomJSFile.getPathToExecutable());
                this.getLog().info((CharSequence)("Extracting " + archive.getAbsolutePath() + " to " + extractTo.getAbsolutePath()));
                if (extractTo.getParentFile().mkdirs()) {
                    archive.cp(extractTo);
                    extractTo.setExecutable(true);
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to download phantomjs binary from " + url, (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to download phantomjs binary from " + url, (Exception)e);
            }
        }
        return extractTo.getAbsolutePath();
    }
}

