/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.extract;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.extract.ExtractionException;
import com.github.klieber.phantomjs.extract.Extractor;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsExtractor
implements Extractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhantomJsExtractor.class);
    private static final String UNABLE_TO_EXTRACT = "Unable to extract phantomjs binary from %s";
    private static final String UNABLE_TO_UNMOUNT = "Unable to unmount file system after extracting";
    private static final String EXTRACTING = "Extracting {} to {}";
    private final PhantomJSArchive phantomJSArchive;

    public PhantomJsExtractor(PhantomJSArchive phantomJSArchive) {
        this.phantomJSArchive = phantomJSArchive;
    }

    @Override
    public void extract(File archive, File extractTo) throws ExtractionException {
        try {
            TFile tfile = new TFile(archive, this.phantomJSArchive.getPathToExecutable());
            LOGGER.info(EXTRACTING, (Object)tfile.getAbsolutePath(), (Object)extractTo.getAbsolutePath());
            if (extractTo.getParentFile().exists() || extractTo.getParentFile().mkdirs()) {
                tfile.cp(extractTo);
                extractTo.setExecutable(true);
            }
        }
        catch (IOException e) {
            throw new ExtractionException(String.format(UNABLE_TO_EXTRACT, archive), e);
        }
        finally {
            this.unmountArchive();
        }
    }

    private void unmountArchive() {
        try {
            TVFS.umount();
        }
        catch (FsSyncException e) {
            LOGGER.error(UNABLE_TO_UNMOUNT, (Throwable)e);
        }
    }
}

