/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.mojo;

import com.github.klieber.phantomjs.exec.ExecutionException;
import com.github.klieber.phantomjs.exec.PhantomJsExecutor;
import com.github.klieber.phantomjs.exec.PhantomJsOptions;
import com.github.klieber.phantomjs.exec.PhantomJsProcessBuilder;
import com.github.klieber.phantomjs.mojo.AbstractPhantomJsMojo;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="exec", defaultPhase=LifecyclePhase.TEST)
public class ExecPhantomJsMojo
extends AbstractPhantomJsMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecPhantomJsMojo.class);
    private static final String EXECUTION_FAILURE = "Failed to execute phantomjs command";
    @Parameter(property="phantomjs.commandLineOptions")
    private String commandLineOptions;
    @Parameter(property="phantomjs.script")
    private String script;
    @Parameter(property="phantomjs.args")
    private List<String> arguments;
    @Parameter(property="phantomjs.configFile")
    private File configFile;

    @Override
    public void run() throws MojoFailureException {
        LOGGER.info("Executing phantomjs command");
        String binary = this.getPhantomJsBinary();
        PhantomJsProcessBuilder builder = new PhantomJsProcessBuilder(binary);
        PhantomJsExecutor executor = new PhantomJsExecutor(builder);
        PhantomJsOptions options = new PhantomJsOptions();
        options.setConfigFile(this.configFile);
        options.setCommandLineOptions(this.commandLineOptions);
        options.addArguments(this.arguments);
        options.setScript(this.script);
        try {
            executor.execute(options);
        }
        catch (ExecutionException e) {
            throw new MojoFailureException(EXECUTION_FAILURE, (Throwable)e);
        }
    }
}

