/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.mojo;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.archive.PhantomJSArchiveBuilder;
import com.github.klieber.phantomjs.cache.CachedArtifact;
import com.github.klieber.phantomjs.config.Configuration;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.download.RepositoryDownloader;
import com.github.klieber.phantomjs.download.RuleBasedDownloader;
import com.github.klieber.phantomjs.download.WebDownloader;
import com.github.klieber.phantomjs.extract.PhantomJsExtractor;
import com.github.klieber.phantomjs.install.WebInstaller;
import com.github.klieber.phantomjs.locate.ArchiveLocator;
import com.github.klieber.phantomjs.locate.CompositeLocator;
import com.github.klieber.phantomjs.locate.Locator;
import com.github.klieber.phantomjs.locate.PathLocator;
import com.github.klieber.phantomjs.mojo.AbstractPhantomJsMojo;
import com.github.klieber.phantomjs.resolve.PhantomJsBinaryResolver;
import com.github.klieber.phantomjs.util.ArtifactBuilder;
import com.github.klieber.phantomjs.util.Predicate;
import com.github.klieber.phantomjs.util.Predicates;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="install", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES)
public class InstallPhantomJsMojo
extends AbstractPhantomJsMojo
implements Configuration {
    private static final String UNABLE_TO_INSTALL = "Failed to install phantomjs.";
    private static final ComparableVersion LEGACY_VERSION = new ComparableVersion("1.9.2");
    private static final Predicate<String> IS_LEGACY_VERSION = new Predicate<String>(){

        @Override
        public boolean apply(String version) {
            return LEGACY_VERSION.compareTo(new ComparableVersion(version)) >= 0;
        }
    };
    private static final String GOOGLE_CODE = "https://phantomjs.googlecode.com/files/";
    private static final String BITBUCKET = "http://cdn.bitbucket.org/ariya/phantomjs/downloads/";
    @Parameter(property="phantomjs.version", required=true)
    private String version;
    @Parameter(property="phantomjs.baseUrl")
    private String baseUrl;
    @Parameter(defaultValue="${project.build.directory}/phantomjs-maven-plugin", property="phantomjs.outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", property="phantomjs.checkSystemPath", required=true)
    private boolean checkSystemPath;
    @Parameter(defaultValue="true", property="phantomjs.enforceVersion", required=true)
    private boolean enforceVersion;
    @Parameter(defaultValue="REPOSITORY", property="phantomjs.source", required=true)
    private Source source;
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    private PhantomJSArchive phantomJSArchive;

    @Inject
    public InstallPhantomJsMojo(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean enforceVersion() {
        return this.enforceVersion;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public PhantomJSArchive getPhantomJsArchive() {
        if (this.phantomJSArchive == null) {
            this.phantomJSArchive = new PhantomJSArchiveBuilder(this.version).build();
        }
        return this.phantomJSArchive;
    }

    @Override
    public void run() throws MojoFailureException {
        CompositeLocator locator = new CompositeLocator(this.getLocators());
        String location = locator.locate();
        if (location == null) {
            throw new MojoFailureException(UNABLE_TO_INSTALL);
        }
        this.setPhantomJsBinary(location);
    }

    private List<Locator> getLocators() {
        ArrayList<Locator> locators = new ArrayList<Locator>();
        if (this.checkSystemPath) {
            locators.add(this.getPathLocator());
        }
        locators.add(this.getArchiveLocator());
        return locators;
    }

    private Locator getPathLocator() {
        String systemPath = System.getenv("PATH");
        List<String> paths = Arrays.asList(systemPath.split(File.pathSeparator));
        return new PathLocator(new PhantomJsBinaryResolver(this), paths);
    }

    private Locator getArchiveLocator() {
        Downloader downloader = this.getDownloader();
        PhantomJsExtractor extractor = new PhantomJsExtractor(this.phantomJSArchive);
        WebInstaller installer = new WebInstaller(this, downloader, extractor);
        return new ArchiveLocator(installer);
    }

    private Downloader getDownloader() {
        ArtifactBuilder artifactBuilder = new ArtifactBuilder();
        CachedArtifact cachedFile = new CachedArtifact(this.getPhantomJsArchive(), artifactBuilder, this.repositorySystemSession);
        Downloader downloader = null;
        if (Source.REPOSITORY.equals((Object)this.source)) {
            downloader = new RepositoryDownloader(artifactBuilder, this.repositorySystem, this.remoteRepositories, this.repositorySystemSession);
        } else if (this.baseUrl == null) {
            HashMap<Downloader, Predicate<String>> rules = new HashMap<Downloader, Predicate<String>>();
            rules.put(new WebDownloader(GOOGLE_CODE, cachedFile.getFile()), IS_LEGACY_VERSION);
            rules.put(new WebDownloader(BITBUCKET, cachedFile.getFile()), Predicates.not(IS_LEGACY_VERSION));
            downloader = new RuleBasedDownloader(rules);
        } else {
            downloader = new WebDownloader(this.baseUrl, cachedFile.getFile());
        }
        return downloader;
    }

    private static enum Source {
        URL,
        REPOSITORY;

    }
}

