/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.resolve;

import com.github.klieber.phantomjs.config.Configuration;
import com.github.klieber.phantomjs.exec.ExecutionException;
import com.github.klieber.phantomjs.exec.PhantomJsOptions;
import com.github.klieber.phantomjs.exec.PhantomJsProcessBuilder;
import com.github.klieber.phantomjs.resolve.BinaryResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsBinaryResolver
implements BinaryResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhantomJsBinaryResolver.class);
    private static final String FOUND_PHANTOMJS = "Found phantomjs {} at {}";
    private static final String SYSTEM_CHECK_FAILURE = "Failed to check system path";
    private static final List<String> BINARY_NAMES = Arrays.asList("phantomjs", "phantomjs.exe");
    private final Configuration config;

    public PhantomJsBinaryResolver(Configuration config) {
        this.config = config;
    }

    @Override
    public String resolve(String path) {
        String binaryName;
        String binaryPath = null;
        Iterator<String> i$ = BINARY_NAMES.iterator();
        while (i$.hasNext() && (binaryPath = this.getBinaryPath(path, binaryName = i$.next())) == null) {
        }
        return binaryPath;
    }

    private String getBinaryPath(String path, String binary) {
        String versionString;
        File file = new File(path, binary);
        if (file.exists() && (versionString = this.getVersion(file.getAbsolutePath())) != null && (!this.config.enforceVersion() || this.config.getVersion().equals(versionString))) {
            LOGGER.info(FOUND_PHANTOMJS, (Object)versionString, (Object)binary);
            return file.getAbsolutePath();
        }
        return null;
    }

    private String getVersion(String binary) {
        PhantomJsOptions options = new PhantomJsOptions();
        options.setCommandLineOptions("-v");
        PhantomJsProcessBuilder builder = new PhantomJsProcessBuilder(binary);
        try {
            Process process = builder.start(options);
            BufferedReader standardOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String versionString = StringUtils.trim((String)standardOut.readLine());
            return process.waitFor() == 0 ? versionString : null;
        }
        catch (ExecutionException e) {
            LOGGER.warn(SYSTEM_CHECK_FAILURE, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn(SYSTEM_CHECK_FAILURE, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn(SYSTEM_CHECK_FAILURE, (Throwable)e);
        }
        return null;
    }
}

