/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.install;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.config.Configuration;
import com.github.klieber.phantomjs.download.DownloadException;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.extract.ExtractionException;
import com.github.klieber.phantomjs.extract.Extractor;
import com.github.klieber.phantomjs.install.InstallationException;
import com.github.klieber.phantomjs.install.Installer;
import java.io.File;

public class WebInstaller
implements Installer {
    private static final String UNABLE_TO_INSTALL = "Unable to install phantomjs.";
    private final Configuration config;
    private final Downloader downloader;
    private final Extractor extractor;

    public WebInstaller(Configuration config, Downloader downloader, Extractor extractor) {
        this.config = config;
        this.downloader = downloader;
        this.extractor = extractor;
    }

    @Override
    public String install() throws InstallationException {
        PhantomJSArchive phantomJSArchive = this.config.getPhantomJsArchive();
        File outputDirectory = this.config.getOutputDirectory();
        File extractTo = new File(outputDirectory, phantomJSArchive.getExtractToPath());
        if (!extractTo.exists()) {
            try {
                File archive = this.downloader.download(phantomJSArchive);
                this.extractor.extract(archive, extractTo);
            }
            catch (DownloadException e) {
                throw new InstallationException(UNABLE_TO_INSTALL, e);
            }
            catch (ExtractionException e) {
                throw new InstallationException(UNABLE_TO_INSTALL, e);
            }
        }
        return extractTo.getAbsolutePath();
    }
}

