/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.download;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.download.DownloadException;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.util.ArtifactBuilder;
import java.io.File;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryDownloader
implements Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryDownloader.class);
    private final String UNABLE_TO_RESOLVE = "Unable to resolve artifact.";
    private final String RESOLVED_ARTIFACT = "Resolved artifact {} from {}";
    private final ArtifactBuilder artifactBuilder;
    private final RepositorySystem repositorySystem;
    private final List<RemoteRepository> remoteRepositories;
    private final RepositorySystemSession repositorySystemSession;

    public RepositoryDownloader(ArtifactBuilder artifactBuilder, RepositorySystem repositorySystem, List<RemoteRepository> remoteRepositories, RepositorySystemSession repositorySystemSession) {
        this.artifactBuilder = artifactBuilder;
        this.repositorySystem = repositorySystem;
        this.remoteRepositories = remoteRepositories;
        this.repositorySystemSession = repositorySystemSession;
    }

    @Override
    public File download(PhantomJSArchive archive) throws DownloadException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(this.artifactBuilder.createArtifact(archive));
        request.setRepositories(this.remoteRepositories);
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
            LOGGER.info("Resolved artifact {} from {}", (Object)result.getArtifact().getFile(), (Object)result.getRepository());
            return result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Unable to resolve artifact.", e);
        }
    }
}

