/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.download;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.download.DownloadException;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.util.Predicate;
import java.io.File;
import java.util.Map;

public class RuleBasedDownloader
implements Downloader {
    private static final String NO_RULES_MATCH = "No matching Downloader found.";
    private final Map<Downloader, Predicate<String>> rules;

    public RuleBasedDownloader(Map<Downloader, Predicate<String>> rules) {
        this.rules = rules;
    }

    @Override
    public File download(PhantomJSArchive archive) throws DownloadException {
        DownloadException exception = null;
        for (Map.Entry<Downloader, Predicate<String>> entry : this.rules.entrySet()) {
            try {
                if (!entry.getValue().apply(archive.getVersion())) continue;
                return entry.getKey().download(archive);
            }
            catch (DownloadException e) {
                exception = e;
            }
        }
        if (exception == null) {
            exception = new DownloadException(NO_RULES_MATCH);
        }
        throw exception;
    }
}

