/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.exec;

import com.github.klieber.phantomjs.exec.ExecutionException;
import com.github.klieber.phantomjs.exec.PhantomJsOptions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhantomJsProcessBuilder.class);
    private static final String PHANTOMJS_COMMAND = "phantomjs command: {}";
    private static final String UNABLE_TO_BUILD_CMD_LINE_OPTIONS = "Unable to build command line options.";
    private static final String UNABLE_TO_START = "Unable to start phantomjs process.";
    private final String phantomJsBinary;

    public PhantomJsProcessBuilder(String phantomJsBinary) {
        this.phantomJsBinary = phantomJsBinary;
    }

    public Process start(PhantomJsOptions options) throws ExecutionException {
        Commandline commandline = this.getCommandLine(options);
        String[] shellCommandline = commandline.getShellCommandline();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(PHANTOMJS_COMMAND, Arrays.asList(shellCommandline));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(shellCommandline);
        if (commandline.getWorkingDirectory() != null) {
            processBuilder.directory(commandline.getWorkingDirectory());
        }
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new ExecutionException(UNABLE_TO_START, e);
        }
    }

    private Commandline getCommandLine(PhantomJsOptions options) throws ExecutionException {
        Commandline commandline = new Commandline(this.phantomJsBinary);
        File configFile = options.getConfigFile();
        if (configFile != null && configFile.exists()) {
            commandline.createArg().setValue("--config=" + configFile.getAbsolutePath());
        } else {
            commandline.addArguments(this.getCommandLineOptions(options.getCommandLineOptions()));
        }
        commandline.createArg().setValue(options.getScript());
        commandline.addArguments(options.getArguments().toArray(new String[options.getArguments().size()]));
        if (options.getWorkingDirectory() != null) {
            commandline.setWorkingDirectory(options.getWorkingDirectory());
        }
        return commandline;
    }

    private String[] getCommandLineOptions(String commandLineOptions) throws ExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)commandLineOptions);
        }
        catch (Exception e) {
            throw new ExecutionException(UNABLE_TO_BUILD_CMD_LINE_OPTIONS, e);
        }
    }
}

