/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.mojo;

import com.github.klieber.phantomjs.locate.PhantomJsLocator;
import com.github.klieber.phantomjs.locate.PhantomJsLocatorOptions;
import com.github.klieber.phantomjs.locate.RepositoryDetails;
import com.github.klieber.phantomjs.mojo.AbstractPhantomJsMojo;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="install", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES)
public class InstallPhantomJsMojo
extends AbstractPhantomJsMojo
implements PhantomJsLocatorOptions {
    private static final String UNABLE_TO_INSTALL = "Failed to install phantomjs.";
    @Parameter(property="phantomjs.version", required=true)
    private String version;
    @Parameter(property="phantomjs.baseUrl")
    private String baseUrl;
    @Parameter(defaultValue="${project.build.directory}/phantomjs-maven-plugin", property="phantomjs.outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", property="phantomjs.checkSystemPath", required=true)
    private boolean checkSystemPath;
    @Parameter(defaultValue="true", property="phantomjs.enforceVersion", required=true)
    private boolean enforceVersion;
    @Parameter(defaultValue="REPOSITORY", property="phantomjs.source", required=true)
    private PhantomJsLocatorOptions.Source source;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    private RepositorySystem repositorySystem;

    @Inject
    public InstallPhantomJsMojo(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public PhantomJsLocatorOptions.Source getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isCheckSystemPath() {
        return this.checkSystemPath;
    }

    public boolean isEnforceVersion() {
        return this.enforceVersion;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void run() throws MojoFailureException {
        RepositoryDetails repositoryDetails = new RepositoryDetails();
        repositoryDetails.setRepositorySystem(this.repositorySystem);
        repositoryDetails.setRepositorySystemSession(this.repositorySystemSession);
        repositoryDetails.setRemoteRepositories(this.remoteRepositories);
        PhantomJsLocator locator = new PhantomJsLocator((PhantomJsLocatorOptions)this, repositoryDetails);
        String location = locator.locate();
        if (location == null) {
            throw new MojoFailureException(UNABLE_TO_INSTALL);
        }
        this.setPhantomJsBinary(location);
    }
}

