/*
 * Decompiled with CFR 0.152.
 */
package javalinjwt;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.InternalServerErrorResponse;
import java.util.Optional;
import javalinjwt.JWTProvider;

public class JavalinJWT {
    private static final String CONTEXT_ATTRIBUTE = "jwt";
    private static final String COOKIE_KEY = "jwt";

    public static boolean containsJWT(Context context) {
        return context.attribute("jwt") != null;
    }

    public static Context addDecodedToContext(Context context, DecodedJWT jwt) {
        context.attribute("jwt", (Object)jwt);
        return context;
    }

    public static DecodedJWT getDecodedFromContext(Context context) {
        Object attribute = context.attribute("jwt");
        if (!(attribute instanceof DecodedJWT)) {
            throw new InternalServerErrorResponse("The context carried invalid object as JavalinJWT");
        }
        return (DecodedJWT)attribute;
    }

    public static Optional<String> getTokenFromHeader(Context context) {
        return Optional.ofNullable(context.header("Authorization")).flatMap(header -> {
            String[] split = header.split(" ");
            if (split.length != 2 || !split[0].equals("Bearer")) {
                return Optional.empty();
            }
            return Optional.of(split[1]);
        });
    }

    public static Optional<String> getTokenFromCookie(Context context) {
        return Optional.ofNullable(context.cookie("jwt"));
    }

    public static Context addTokenToCookie(Context context, String token) {
        return context.cookie("jwt", token);
    }

    public static <T> Handler createHeaderDecodeHandler(JWTProvider<T> jwtProvider) {
        return context -> JavalinJWT.getTokenFromHeader(context).flatMap(jwtProvider::validateToken).ifPresent(jwt -> JavalinJWT.addDecodedToContext(context, jwt));
    }

    public static <T> Handler createCookieDecodeHandler(JWTProvider<T> jwtProvider) {
        return context -> JavalinJWT.getTokenFromCookie(context).flatMap(jwtProvider::validateToken).ifPresent(jwt -> JavalinJWT.addDecodedToContext(context, jwt));
    }
}

