/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojos;

import com.knightliao.plugin.starter.shade.utils.MavenFileUtils;
import com.knightliao.plugin.starter.shade.utils.TarFileUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.mojo.ShadeMojo;
import org.apache.maven.plugins.shade.mojos.BaseStarterMojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="shade", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class StarterShade
extends BaseStarterMojo {
    public static final String FORMAT = "shade";
    @Parameter
    private File startShell;
    @Parameter
    private File stopShell;
    @Parameter
    private String folderName = "starter-run";
    @Parameter
    private boolean includeProfileResource = false;

    protected String getFormat() {
        return FORMAT;
    }

    public void execute() throws MojoExecutionException {
        String dir;
        String finalFileName;
        Field field;
        Map context = this.getPluginContext();
        MavenProject mavenProject = (MavenProject)context.get("project");
        this.getLog().info((CharSequence)mavenProject.toString());
        if (this.startShell != null) {
            MavenFileUtils.copyFile(mavenProject, this.folderName, this.startShell, "start.sh");
        } else {
            this.getLog().info((CharSequence)"use default start shell");
            MavenFileUtils.copyFile(mavenProject, this.folderName, StarterShade.class.getResource("/META-INF/start.sh"), "start.sh");
        }
        if (this.stopShell != null) {
            MavenFileUtils.copyFile(mavenProject, this.folderName, this.stopShell, "stop.sh");
        } else {
            this.getLog().info((CharSequence)"use default stop shell");
            MavenFileUtils.copyFile(mavenProject, this.folderName, StarterShade.class.getResource("/META-INF/stop.sh"), "stop.sh");
        }
        ArrayList resources = new ArrayList();
        List activeProfiles = mavenProject.getActiveProfiles();
        for (Profile profile : activeProfiles) {
            this.getLog().info((CharSequence)String.format("add resource for profile %s", profile));
            BuildBase buildBase = profile.getBuild();
            if (buildBase == null) continue;
            List curResources = buildBase.getResources();
            resources.addAll(curResources);
        }
        for (Resource resource : resources) {
            String directory = resource.getDirectory();
            if (!new File(directory).isDirectory()) continue;
            Collection files = FileUtils.listFilesAndDirs((File)new File(directory), (IOFileFilter)FileFilterUtils.trueFileFilter(), (IOFileFilter)FileFilterUtils.trueFileFilter());
            for (File file : files) {
                this.getLog().info((CharSequence)String.format("add file:[%s] as conf", file.getAbsolutePath()));
                MavenFileUtils.copyFile(mavenProject, this.folderName, file, file.getAbsolutePath().replace(directory, ""));
            }
        }
        super.execute();
        try {
            field = ShadeMojo.class.getDeclaredField("finalName");
            field.setAccessible(true);
            finalFileName = (String)field.get((Object)this);
            this.getLog().info((CharSequence)finalFileName);
            dir = mavenProject.getBuild().getDirectory();
            finalFileName = finalFileName + "." + mavenProject.getArtifact().getArtifactHandler().getExtension();
            File finalFile = new File(dir, finalFileName);
            MavenFileUtils.copyFile(mavenProject, this.folderName, finalFile, finalFileName);
            this.getLog().info((CharSequence)String.format("mv %s to folder %s", finalFile, this.folderName));
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)e.toString(), (Throwable)e);
        }
        try {
            field = ShadeMojo.class.getDeclaredField("finalName");
            field.setAccessible(true);
            finalFileName = (String)field.get((Object)this);
            this.getLog().info((CharSequence)String.format("make %s", this.folderName + ".tar.gz"));
            dir = mavenProject.getBuild().getDirectory();
            TarFileUtils.createDirTarGz(dir + File.separator + this.folderName, dir + File.separator + finalFileName + ".tar.gz");
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.toString());
        }
    }
}

