/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.lang3.ArrayUtils;

public class PacketBuffer {
    private ByteBuffer byteBuffer;

    public PacketBuffer(byte[] data) {
        this.byteBuffer = ByteBuffer.wrap(data);
    }

    public byte[] array() {
        return this.byteBuffer.array();
    }

    public byte getByte() {
        return this.byteBuffer.get();
    }

    public float getFloat() {
        return this.byteBuffer.getFloat();
    }

    public int getInt() {
        return this.byteBuffer.getInt();
    }

    public int getLength() {
        return this.byteBuffer.capacity();
    }

    public short getShort() {
        return this.byteBuffer.getShort();
    }

    public String getString() {
        byte[] remainingBytes = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(remainingBytes);
        int zeroPosition = ArrayUtils.indexOf((byte[])remainingBytes, (byte)0);
        if (zeroPosition == -1) {
            return null;
        }
        byte[] stringBytes = new byte[zeroPosition];
        System.arraycopy(remainingBytes, 0, stringBytes, 0, zeroPosition);
        this.byteBuffer.position(this.byteBuffer.position() + zeroPosition + 1);
        return new String(stringBytes);
    }

    public PacketBuffer order(ByteOrder byteOrder) {
        this.byteBuffer.order(byteOrder);
        return this;
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }

    public boolean hasRemaining() {
        return this.byteBuffer.hasRemaining();
    }
}

