/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.exceptions;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;

public class WebApiException
extends SteamCondenserException {
    private String message;

    public WebApiException(String message) {
        super(message);
    }

    public WebApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public WebApiException(Cause cause) {
        this(cause, null, null);
    }

    public WebApiException(Cause cause, Integer statusCode, String statusMessage) {
        switch (cause) {
            case HTTP_ERROR: {
                this.message = "The Web API request has failed due to an HTTP error: " + statusMessage + " (status code: " + statusCode + ").";
                break;
            }
            case INVALID_KEY: {
                this.message = "This is not a valid Steam Web API key.";
                break;
            }
            case STATUS_BAD: {
                this.message = "The Web API request failed with the following error: " + statusMessage + " (status code: " + statusCode + ").";
                break;
            }
            case UNAUTHORIZED: {
                this.message = "Your Web API request has been rejected. You most likely did not specify a valid Web API key.";
                break;
            }
            default: {
                this.message = "An unexpected error occured while executing a Web API request.";
            }
        }
    }

    public String getMessage() {
        if (this.message == null) {
            return super.getMessage();
        }
        return this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        HTTP_ERROR,
        INVALID_KEY,
        STATUS_BAD,
        UNAUTHORIZED;

    }
}

