/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteamPlayer {
    private int clientPort;
    private float connectTime;
    private boolean extended;
    private int id;
    private String ipAddress;
    private int loss;
    private String name;
    private int ping;
    private int rate;
    private int realId;
    private int score;
    private String state;
    private String steamId;

    public SteamPlayer(int id, String name, int score, float connectTime) {
        this.connectTime = connectTime;
        this.id = id;
        this.name = name;
        this.score = score;
        this.extended = false;
    }

    public void addInformation(Map<String, String> playerData) throws SteamCondenserException {
        if (!playerData.get("name").equals(this.name)) {
            throw new SteamCondenserException("Information to add belongs to a different player.");
        }
        this.extended = true;
        this.realId = Integer.parseInt(playerData.get("userid"));
        this.steamId = playerData.get("uniqueid");
        if (playerData.containsKey("state")) {
            this.state = playerData.get("state");
        }
        if (!this.isBot()) {
            this.loss = Integer.parseInt(playerData.get("loss"));
            this.ping = Integer.parseInt(playerData.get("ping"));
            if (playerData.containsKey("adr")) {
                String[] address = playerData.get("adr").split(":");
                this.ipAddress = address[0];
                this.clientPort = Integer.parseInt(address[1]);
            }
            if (playerData.containsKey("rate")) {
                this.rate = Integer.parseInt(playerData.get("rate"));
            }
        }
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public float getConnectTime() {
        return this.connectTime;
    }

    public int getId() {
        return this.id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getLoss() {
        return this.loss;
    }

    public String getName() {
        return this.name;
    }

    public int getPing() {
        return this.ping;
    }

    public int getRate() {
        return this.rate;
    }

    public int getRealId() {
        return this.realId;
    }

    public int getScore() {
        return this.score;
    }

    public String getState() {
        return this.state;
    }

    public String getSteamId() {
        return this.steamId;
    }

    public boolean isBot() {
        return this.steamId.equals("BOT");
    }

    public boolean isExtended() {
        return this.extended;
    }

    public String toString() {
        if (this.extended) {
            return "#" + this.realId + " \"" + this.name + "\", SteamID: " + this.steamId + ", Score: " + this.score + ", Time: " + this.connectTime;
        }
        return "#" + this.id + " \"" + this.name + "\", Score: " + this.score + ", Time: " + this.connectTime;
    }
}

