/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppNews {
    private int appId;
    private String author;
    private String contents;
    private Date date;
    private boolean external;
    private String feedLabel;
    private String feedName;
    private long gid;
    private String title;
    private String url;

    public static List<AppNews> getNewsForApp(int appId) throws WebApiException {
        return AppNews.getNewsForApp(appId, 5, null);
    }

    public static List<AppNews> getNewsForApp(int appId, int count) throws WebApiException {
        return AppNews.getNewsForApp(appId, count, null);
    }

    public static List<AppNews> getNewsForApp(int appId, int count, Integer maxLength) throws WebApiException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appid", appId);
            params.put("count", count);
            params.put("maxlength", maxLength);
            JSONObject data = new JSONObject(WebApi.getJSON("ISteamNews", "GetNewsForApp", 2, params));
            ArrayList<AppNews> newsItems = new ArrayList<AppNews>();
            JSONArray newsData = data.getJSONObject("appnews").getJSONArray("newsitems");
            for (int i = 0; i < newsData.length(); ++i) {
                newsItems.add(new AppNews(appId, newsData.getJSONObject(i)));
            }
            return newsItems;
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
    }

    private AppNews(int appId, JSONObject newsData) throws WebApiException {
        try {
            this.appId = appId;
            this.author = newsData.getString("author");
            this.contents = newsData.getString("contents").trim();
            this.date = new Date(newsData.getLong("date"));
            this.external = newsData.getBoolean("is_external_url");
            this.feedLabel = newsData.getString("feedlabel");
            this.feedName = newsData.getString("feedname");
            this.gid = newsData.getLong("gid");
            this.title = newsData.getString("title");
            this.url = newsData.getString("url");
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
    }

    public int getAppId() {
        return this.appId;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContents() {
        return this.contents;
    }

    public Date getDate() {
        return this.date;
    }

    public String getFeedLabel() {
        return this.feedLabel;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public long getGid() {
        return this.gid;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String toString() {
        return this.feedLabel + ": " + this.getTitle();
    }
}

