/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.SteamGame;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameAchievement {
    private String apiName;
    private String description;
    private SteamGame game;
    private String iconClosedUrl;
    private String iconOpenUrl;
    private String name;
    private Date timestamp;
    private boolean unlocked;
    private SteamId user;

    public static Map<String, Double> getGlobalPercentages(int appId) throws WebApiException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("gameid", appId);
        try {
            JSONObject data = new JSONObject(WebApi.getJSON("ISteamUserStats", "GetGlobalAchievementPercentagesForApp", 2, params));
            HashMap<String, Double> percentages = new HashMap<String, Double>();
            JSONArray achievementsData = data.getJSONObject("achievementpercentages").getJSONArray("achievements");
            for (int i = 0; i < achievementsData.length(); ++i) {
                JSONObject achievementData = achievementsData.getJSONObject(i);
                percentages.put(achievementData.getString("name"), achievementData.getDouble("percent"));
            }
            return percentages;
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
    }

    public GameAchievement(SteamId user, SteamGame game, XMLData achievementData) {
        this.apiName = achievementData.getString("apiname");
        this.description = achievementData.getString("description");
        this.game = game;
        this.iconClosedUrl = achievementData.getString("iconClosed");
        this.iconOpenUrl = achievementData.getString("iconOpen");
        this.name = achievementData.getString("name");
        this.unlocked = achievementData.getAttribute("closed").equals("1");
        this.user = user;
        if (this.unlocked && achievementData.hasElement("unlockTimestamp")) {
            this.timestamp = new Date(achievementData.getLong("unlockTimestamp") * 1000L);
        }
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getDescription() {
        return this.description;
    }

    public SteamGame getGame() {
        return this.game;
    }

    public String getIconClosedURL() {
        return this.iconClosedUrl;
    }

    public String getIconOpenURL() {
        return this.iconOpenUrl;
    }

    public String getName() {
        return this.name;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public SteamId getUser() {
        return this.user;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }
}

