/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.GameItem;
import com.github.koraktor.steamcondenser.steam.community.GameItemSchema;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import com.github.koraktor.steamcondenser.steam.community.dota2.Dota2BetaInventory;
import com.github.koraktor.steamcondenser.steam.community.dota2.Dota2Inventory;
import com.github.koraktor.steamcondenser.steam.community.portal2.Portal2Inventory;
import com.github.koraktor.steamcondenser.steam.community.tf2.TF2BetaInventory;
import com.github.koraktor.steamcondenser.steam.community.tf2.TF2Inventory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInventory {
    public static Map<Integer, Map<Long, GameInventory>> cache = new HashMap<Integer, Map<Long, GameInventory>>();
    private static String schemaLanguage = "en";
    private int appId;
    private Date fetchDate;
    private GameItemSchema itemSchema;
    private Map<Integer, GameItem> items;
    private List<GameItem> preliminaryItems;
    private long steamId64;
    private SteamId user;

    public static void clearCache() {
        cache.clear();
    }

    public static GameInventory create(int appId, long steamId64) throws SteamCondenserException {
        return GameInventory.create(appId, steamId64, true, false);
    }

    public static GameInventory create(int appId, String vanityUrl) throws SteamCondenserException {
        return GameInventory.create(appId, vanityUrl, true, false);
    }

    public static GameInventory create(int appId, String vanityUrl, boolean fetchNow, boolean bypassCache) throws SteamCondenserException {
        long steamId64 = SteamId.resolveVanityUrl(vanityUrl);
        return GameInventory.create(appId, steamId64, fetchNow, bypassCache);
    }

    public static GameInventory create(int appId, long steamId64, boolean fetchNow, boolean bypassCache) throws SteamCondenserException {
        if (GameInventory.isCached(appId, steamId64) && !bypassCache) {
            GameInventory inventory = cache.get(appId).get(steamId64);
            if (fetchNow && !inventory.isFetched()) {
                inventory.fetch();
            }
            return inventory;
        }
        switch (appId) {
            case 205790: {
                return new Dota2BetaInventory(steamId64, fetchNow);
            }
            case 570: {
                return new Dota2Inventory(steamId64, fetchNow);
            }
            case 620: {
                return new Portal2Inventory(steamId64, fetchNow);
            }
            case 520: {
                return new TF2BetaInventory(steamId64, fetchNow);
            }
            case 440: {
                return new TF2Inventory(steamId64, fetchNow);
            }
        }
        return new GameInventory(appId, steamId64, fetchNow);
    }

    public static boolean isCached(int appId, long steamId64) {
        return cache.containsKey(appId) && cache.get(appId).containsKey(steamId64);
    }

    public static void setSchemaLanguage(String language) {
        schemaLanguage = language;
    }

    protected GameInventory(int appId, Object steamId, boolean fetchNow) throws SteamCondenserException {
        this.appId = appId;
        this.steamId64 = steamId instanceof String ? SteamId.resolveVanityUrl((String)steamId).longValue() : ((Long)steamId).longValue();
        this.user = SteamId.create(this.steamId64, false);
        if (fetchNow) {
            this.fetch();
        }
        this.cache();
    }

    public void fetch() throws SteamCondenserException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("SteamID", this.steamId64);
            JSONObject result = WebApi.getJSONData("IEconItems_" + this.getAppId(), "GetPlayerItems", 1, params);
            this.items = new HashMap<Integer, GameItem>();
            this.preliminaryItems = new ArrayList<GameItem>();
            JSONArray itemsData = result.getJSONArray("items");
            for (int i = 0; i < itemsData.length(); ++i) {
                JSONObject itemData = itemsData.getJSONObject(i);
                if (itemData == null) continue;
                try {
                    GameItem item = this.getItemClass().getConstructor(this.getClass(), JSONObject.class).newInstance(this, itemData);
                    if (item.isPreliminary()) {
                        this.preliminaryItems.add(item);
                        continue;
                    }
                    this.items.put(item.getBackpackPosition() - 1, item);
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                catch (InstantiationException e) {
                    continue;
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof SteamCondenserException) {
                        throw (SteamCondenserException)e.getCause();
                    }
                    throw (RuntimeException)e.getCause();
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
        this.fetchDate = new Date();
    }

    public int getAppId() {
        return this.appId;
    }

    public GameItem getItem(int index) {
        return this.items.get(index - 1);
    }

    protected Class<? extends GameItem> getItemClass() {
        return GameItem.class;
    }

    public GameItemSchema getItemSchema() throws SteamCondenserException {
        if (this.itemSchema == null) {
            this.itemSchema = GameItemSchema.create(this.appId, schemaLanguage);
        }
        return this.itemSchema;
    }

    public Map<Integer, GameItem> getItems() {
        return this.items;
    }

    public List<GameItem> getPreliminaryItems() {
        return this.preliminaryItems;
    }

    public SteamId getUser() {
        return this.user;
    }

    public boolean isFetched() {
        return this.fetchDate != null;
    }

    public int size() {
        return this.items.size();
    }

    private void cache() {
        Map<Long, GameInventory> gameCache = cache.containsKey(this.appId) ? cache.get(this.appId) : new HashMap<Long, GameInventory>();
        gameCache.put(this.steamId64, this);
    }
}

