/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.GameInventory;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameItem {
    private List<JSONObject> attributes;
    private int backpackPosition;
    private int count;
    private boolean craftable;
    private int defindex;
    private int id;
    private GameInventory inventory;
    private String itemClass;
    private JSONObject itemSet;
    private int level;
    private String name;
    private String origin;
    private int originalId;
    private boolean preliminary;
    private String quality;
    private boolean tradeable;
    private String type;

    public GameItem(GameInventory inventory, JSONObject itemData) throws SteamCondenserException {
        this.inventory = inventory;
        try {
            JSONArray attributesData;
            this.defindex = itemData.getInt("defindex");
            this.backpackPosition = (int)itemData.getLong("inventory") & 0xFFFF;
            this.count = itemData.getInt("quantity");
            this.craftable = !itemData.optBoolean("flag_cannot_craft");
            this.id = itemData.getInt("id");
            this.itemClass = this.getSchemaData().getString("item_class");
            this.itemSet = this.inventory.getItemSchema().getItemSets().get(this.getSchemaData().optString("item_set"));
            this.level = itemData.getInt("level");
            this.name = this.getSchemaData().getString("item_name");
            this.preliminary = (itemData.getLong("inventory") & 0x40000000L) != 0L;
            this.originalId = itemData.getInt("original_id");
            this.quality = this.inventory.getItemSchema().getQualities().get(itemData.getInt("quality"));
            this.tradeable = !itemData.optBoolean("flag_cannot_trade");
            this.type = this.getSchemaData().getString("item_type_name");
            if (itemData.has("origin")) {
                this.origin = this.inventory.getItemSchema().getOrigins().get(itemData.getInt("origin"));
            }
            if ((attributesData = this.getSchemaData().optJSONArray("attributes")) == null) {
                attributesData = new JSONArray();
            }
            if (itemData.has("attributes")) {
                JSONArray itemAttributes = itemData.getJSONArray("attributes");
                for (int i = 0; i < itemAttributes.length(); ++i) {
                    attributesData.put(itemAttributes.get(i));
                }
            }
            this.attributes = new ArrayList<JSONObject>();
            for (int i = 0; i < attributesData.length(); ++i) {
                JSONObject attributeData = attributesData.getJSONObject(i);
                Object attributeKey = attributeData.opt("defindex");
                if (attributeKey == null) {
                    attributeKey = attributeData.opt("name");
                }
                if (attributeKey == null) continue;
                JSONObject schemaAttributeData = inventory.getItemSchema().getAttributes().get(attributeKey);
                for (String key : JSONObject.getNames((JSONObject)schemaAttributeData)) {
                    attributeData.put(key, schemaAttributeData.get(key));
                }
                this.attributes.add(attributeData);
            }
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
    }

    public List<JSONObject> getAttributes() {
        return this.attributes;
    }

    public int getBackpackPosition() {
        return this.backpackPosition;
    }

    public int getCount() {
        return this.count;
    }

    public int getDefIndex() {
        return this.defindex;
    }

    public int getId() {
        return this.id;
    }

    public GameInventory getInventory() {
        return this.inventory;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public JSONObject getItemSet() {
        return this.itemSet;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getOrigin() {
        return this.origin;
    }

    public int getOriginalId() {
        return this.originalId;
    }

    public String getQuality() {
        return this.quality;
    }

    public JSONObject getSchemaData() throws SteamCondenserException {
        return this.inventory.getItemSchema().getItems().get(this.defindex);
    }

    public String getType() {
        return this.type;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public boolean isPreliminary() {
        return this.preliminary;
    }

    public boolean isTradeable() {
        return this.tradeable;
    }
}

