/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameItemSchema {
    private static Map<Integer, Map<String, GameItemSchema>> cache = new HashMap<Integer, Map<String, GameItemSchema>>();
    private int appId;
    private Map<Object, JSONObject> attributes;
    private Map<Integer, JSONObject> effects;
    private Date fetchDate;
    private Map<String, Object> itemLevels;
    private Map<String, Integer> itemNames;
    private Map<String, JSONObject> itemSets;
    private Map<Integer, JSONObject> items;
    private String language;
    private Map<Integer, String> origins;
    private Map<Integer, String> qualities;

    public static void clearCache() {
        cache.clear();
    }

    public static GameItemSchema create(int appId, String language) throws SteamCondenserException {
        return GameItemSchema.create(appId, language, true, false);
    }

    public static GameItemSchema create(int appId, String language, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        if (GameItemSchema.isCached(appId, language) && !bypassCache) {
            GameItemSchema itemSchema = cache.get(appId).get(language);
            if (fetch && !itemSchema.isFetched()) {
                itemSchema.fetch();
            }
            return itemSchema;
        }
        return new GameItemSchema(appId, language, fetch);
    }

    public static boolean isCached(int appId, String language) {
        return cache.containsKey(appId) && cache.get(appId).containsKey(language);
    }

    protected GameItemSchema(int appId, String language, boolean fetch) throws WebApiException {
        this.appId = appId;
        this.language = language;
        if (fetch) {
            this.fetch();
        }
    }

    public void fetch() throws WebApiException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("language", this.language);
            JSONObject data = WebApi.getJSONData("IEconItems_" + this.appId, "GetSchema", 1, params);
            this.attributes = new HashMap<Object, JSONObject>();
            JSONArray attributesData = data.getJSONArray("attributes");
            for (int i = 0; i < attributesData.length(); ++i) {
                JSONObject attribute = attributesData.getJSONObject(i);
                this.attributes.put(attribute.getInt("defindex"), attribute);
                this.attributes.put(attribute.getString("name"), attribute);
            }
            this.effects = new HashMap<Integer, JSONObject>();
            JSONArray effectsData = data.getJSONArray("attribute_controlled_attached_particles");
            for (int i = 0; i < effectsData.length(); ++i) {
                JSONObject effect = effectsData.getJSONObject(i);
                this.effects.put(effect.getInt("id"), effect);
            }
            this.items = new HashMap<Integer, JSONObject>();
            this.itemNames = new HashMap<String, Integer>();
            JSONArray itemsData = data.getJSONArray("items");
            for (int i = 0; i < itemsData.length(); ++i) {
                JSONObject item = itemsData.getJSONObject(i);
                this.items.put(item.getInt("defindex"), item);
                this.itemNames.put(item.getString("name"), item.getInt("defindex"));
            }
            if (data.has("levels")) {
                this.itemLevels = new HashMap<String, Object>();
                JSONArray itemsLevelsData = data.getJSONArray("item_levels");
                for (int i = 0; i < itemsLevelsData.length(); ++i) {
                    JSONObject itemLevelType = itemsLevelsData.getJSONObject(i);
                    HashMap<Integer, String> itemLevels = new HashMap<Integer, String>();
                    this.itemLevels.put(itemLevelType.getString("name"), itemLevels);
                    for (int j = 0; j < itemLevelType.getJSONArray("levels").length(); ++j) {
                        JSONObject itemLevel = itemLevelType.getJSONArray("levels").getJSONObject(j);
                        itemLevels.put(itemLevel.getInt("level"), itemLevel.getString("name"));
                    }
                }
            }
            this.itemSets = new HashMap<String, JSONObject>();
            JSONArray itemSetsData = data.getJSONArray("item_sets");
            for (int i = 0; i < itemSetsData.length(); ++i) {
                JSONObject itemSet = itemSetsData.getJSONObject(i);
                this.itemSets.put(itemSet.getString("item_set"), itemSet);
            }
            this.origins = new HashMap<Integer, String>();
            JSONArray originsData = data.getJSONArray("originNames");
            for (int i = 0; i < originsData.length(); ++i) {
                JSONObject origin = originsData.getJSONObject(i);
                this.origins.put(origin.getInt("origin"), origin.getString("name"));
            }
            this.qualities = new HashMap<Integer, String>();
            JSONObject qualitiesData = data.getJSONObject("qualities");
            Iterator qualityKeys = qualitiesData.keys();
            int index = -1;
            while (qualityKeys.hasNext()) {
                String key = (String)qualityKeys.next();
                String qualityName = data.getJSONObject("qualityNames").optString(key, WordUtils.capitalize((String)key));
                this.qualities.put(++index, qualityName);
            }
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
        this.cache();
        this.fetchDate = new Date();
    }

    public boolean isFetched() {
        return this.fetchDate != null;
    }

    public String toString() {
        Object fetchDate = this.fetchDate == null ? "not fetched" : this.fetchDate;
        return String.format("%s[%d (%s) - %s]", this.getClass().getName(), this.appId, this.language, fetchDate);
    }

    public int getAppId() {
        return this.appId;
    }

    public Map<Object, JSONObject> getAttributes() {
        return this.attributes;
    }

    public Map<Integer, JSONObject> getEffects() {
        return this.effects;
    }

    public Map<String, Object> getItemLevels() {
        return this.itemLevels;
    }

    public Map<String, Integer> getItemNames() {
        return this.itemNames;
    }

    public Map<String, JSONObject> getItemSets() {
        return this.itemSets;
    }

    public Map<Integer, JSONObject> getItems() {
        return this.items;
    }

    public String getLanguage() {
        return this.language;
    }

    public Map<Integer, String> getOrigins() {
        return this.origins;
    }

    public Map<Integer, String> getQualities() {
        return this.qualities;
    }

    private void cache() {
        Map<String, GameItemSchema> gameCache = cache.containsKey(this.appId) ? cache.get(this.appId) : new HashMap<String, GameItemSchema>();
        gameCache.put(this.language, this);
    }
}

