/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameLeaderboardEntry;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameLeaderboard {
    public static final int LEADERBOARD_DISPLAY_TYPE_NONE = 0;
    public static final int LEADERBOARD_DISPLAY_TYPE_NUMERIC = 1;
    public static final int LEADERBOARD_DISPLAY_TYPE_SECONDS = 2;
    public static final int LEADERBOARD_DISPLAY_TYPE_MILLISECONDS = 3;
    public static final int LEADERBOARD_SORT_METHOD_NONE = 0;
    public static final int LEADERBOARD_SORT_METHOD_ASC = 1;
    public static final int LEADERBOARD_SORT_METHOD_DESC = 2;
    private static Map<String, Map<Integer, GameLeaderboard>> leaderboards = new HashMap<String, Map<Integer, GameLeaderboard>>();
    protected int id;
    protected String url;
    protected String name;
    protected int entryCount;
    protected int sortMethod;
    protected int displayType;

    public static void clearCache() {
        leaderboards.clear();
    }

    public static GameLeaderboard getLeaderboard(String gameName, int id) throws SteamCondenserException {
        return GameLeaderboard.getLeaderboards(gameName).get(id);
    }

    public static GameLeaderboard getLeaderboard(String gameName, String name) throws SteamCondenserException {
        Map<Integer, GameLeaderboard> leaderboards = GameLeaderboard.getLeaderboards(gameName);
        for (GameLeaderboard board : leaderboards.values()) {
            if (!board.getName().equals(name)) continue;
            return board;
        }
        return null;
    }

    public static Map<Integer, GameLeaderboard> getLeaderboards(String gameName) throws SteamCondenserException {
        if (!leaderboards.containsKey(gameName)) {
            GameLeaderboard.loadLeaderboards(gameName);
        }
        return leaderboards.get(gameName);
    }

    private static void loadLeaderboards(String gameName) throws SteamCondenserException {
        String url = String.format("http://steamcommunity.com/stats/%s/leaderboards/?xml=1", gameName);
        try {
            XMLData boardsData = new XMLData(url);
            if (boardsData.hasElement("error")) {
                throw new SteamCondenserException(boardsData.getString("error"));
            }
            leaderboards.put(gameName, new HashMap());
            for (XMLData boardData : boardsData.getElements("leaderboard")) {
                GameLeaderboard leaderboard = new GameLeaderboard(boardData);
                leaderboards.get(gameName).put(leaderboard.getId(), leaderboard);
            }
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }

    private GameLeaderboard(XMLData boardData) {
        this.url = boardData.getString("url");
        this.id = boardData.getInteger("lbid");
        this.name = boardData.getString("name");
        this.entryCount = boardData.getInteger("entries");
        this.sortMethod = boardData.getInteger("sortmethod");
        this.displayType = boardData.getInteger("displaytype");
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getSortMethod() {
        return this.sortMethod;
    }

    public GameLeaderboardEntry getEntryForSteamId(SteamId steamId) throws SteamCondenserException {
        return this.getEntryForSteamId(steamId.getSteamId64());
    }

    public GameLeaderboardEntry getEntryForSteamId(long steamId) throws SteamCondenserException {
        String url = String.format("%s&steamid=%s", this.url, steamId);
        try {
            XMLData boardData = new XMLData(url);
            if (boardData.hasElement("error")) {
                throw new SteamCondenserException(boardData.getString("error"));
            }
            for (XMLData entryData : boardData.getElements("entries", "entry")) {
                if (entryData.getLong("steamid") != steamId) continue;
                return new GameLeaderboardEntry(entryData, this);
            }
            return null;
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }

    public Map<Integer, GameLeaderboardEntry> getEntryForSteamIdFriends(SteamId steamId) throws SteamCondenserException {
        return this.getEntryForSteamIdFriends(steamId.getSteamId64());
    }

    public Map<Integer, GameLeaderboardEntry> getEntryForSteamIdFriends(long steamId) throws SteamCondenserException {
        String url = String.format("%s&steamid=%s", this.url, steamId);
        try {
            XMLData boardData = new XMLData(url);
            if (boardData.hasElement("error")) {
                throw new SteamCondenserException(boardData.getString("error"));
            }
            HashMap<Integer, GameLeaderboardEntry> entries = new HashMap<Integer, GameLeaderboardEntry>();
            for (XMLData entryData : boardData.getElements("entries", "entry")) {
                GameLeaderboardEntry entry = new GameLeaderboardEntry(entryData, this);
                entries.put(entry.getRank(), entry);
            }
            return entries;
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }

    public Map<Integer, GameLeaderboardEntry> getEntryRange(int first, int last) throws SteamCondenserException {
        if (last < first) {
            throw new SteamCondenserException("First entry must be prior to last entry for leaderboard entry lookup.");
        }
        if (last - first > 5000) {
            throw new SteamCondenserException("Leaderboard entry lookup is currently limited to a maximum of 5001 entries per request.");
        }
        String url = String.format("%s&start=%d&end=%d", this.url, first, last);
        try {
            XMLData boardData = new XMLData(url);
            if (boardData.hasElement("error")) {
                throw new SteamCondenserException(boardData.getString("error"));
            }
            HashMap<Integer, GameLeaderboardEntry> entries = new HashMap<Integer, GameLeaderboardEntry>();
            for (XMLData entryData : boardData.getElements("entries", "entry")) {
                GameLeaderboardEntry entry = new GameLeaderboardEntry(entryData, this);
                entries.put(entry.getRank(), entry);
            }
            return entries;
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }
}

