/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameLeaderboard;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.XMLData;

public class GameLeaderboardEntry {
    protected SteamId steamId;
    protected int score;
    protected int rank;
    protected GameLeaderboard leaderboard;

    public GameLeaderboardEntry(XMLData entryData, GameLeaderboard leaderboard) {
        try {
            this.steamId = SteamId.create(entryData.getString("steamid"), false);
        }
        catch (SteamCondenserException steamCondenserException) {
            // empty catch block
        }
        this.score = entryData.getInteger("score");
        this.rank = entryData.getInteger("rank");
        this.leaderboard = leaderboard;
    }

    public SteamId getSteamId() {
        return this.steamId;
    }

    public int getScore() {
        return this.score;
    }

    public int getRank() {
        return this.rank;
    }

    public GameLeaderboard getLeaderboard() {
        return this.leaderboard;
    }
}

