/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameAchievement;
import com.github.koraktor.steamcondenser.steam.community.SteamGame;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.css.CSSStats;
import com.github.koraktor.steamcondenser.steam.community.defense_grid.DefenseGridStats;
import com.github.koraktor.steamcondenser.steam.community.dods.DoDSStats;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4D2Stats;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DStats;
import com.github.koraktor.steamcondenser.steam.community.portal2.Portal2Stats;
import com.github.koraktor.steamcondenser.steam.community.tf2.TF2Stats;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameStats {
    protected ArrayList<GameAchievement> achievements;
    protected int achievementsDone;
    protected SteamGame game;
    protected String hoursPlayed;
    protected String privacyState;
    protected SteamId user;
    protected XMLData xmlData;

    public static GameStats createGameStats(Object steamId, String gameName) throws SteamCondenserException {
        if (gameName.equals("cs:s")) {
            return new CSSStats(steamId);
        }
        if (gameName.equals("defensegrid:awakening")) {
            return new DefenseGridStats(steamId);
        }
        if (gameName.equals("dod:s")) {
            return new DoDSStats(steamId);
        }
        if (gameName.equals("l4d")) {
            return new L4DStats(steamId);
        }
        if (gameName.equals("l4d2")) {
            return new L4D2Stats(steamId);
        }
        if (gameName.equals("portal2")) {
            return new Portal2Stats(steamId);
        }
        if (gameName.equals("tf2")) {
            return new TF2Stats(steamId);
        }
        return new GameStats(steamId, gameName);
    }

    protected static String getBaseUrl(Object userId, Object gameId) {
        String gameUrl = gameId instanceof Integer ? "appid/" + gameId : (String)gameId;
        if (userId instanceof Long) {
            return "http://steamcommunity.com/profiles/" + userId + "/stats/" + gameUrl;
        }
        return "http://steamcommunity.com/id/" + userId + "/stats/" + gameUrl;
    }

    protected GameStats(Object steamId, Object gameId) throws SteamCondenserException {
        if (steamId instanceof String) {
            this.user = SteamId.create((String)steamId, false);
        } else if (steamId instanceof Long) {
            this.user = SteamId.create((Long)steamId, false);
        }
        try {
            this.xmlData = new XMLData(GameStats.getBaseUrl(steamId, gameId) + "?xml=all");
            if (this.xmlData.hasElement("error")) {
                throw new SteamCondenserException(this.xmlData.getString("error"));
            }
            this.privacyState = this.xmlData.getString("privacyState");
            if (this.isPublic()) {
                Pattern appIdPattern = Pattern.compile("http://steamcommunity\\.com/+app/+([1-9][0-9]*)", 2);
                Matcher appIdMatcher = appIdPattern.matcher(this.xmlData.getString("game", "gameLink"));
                appIdMatcher.find();
                int appId = Integer.parseInt(appIdMatcher.group(1));
                this.game = SteamGame.create(appId, this.xmlData.getElement("game"));
                this.hoursPlayed = this.xmlData.getString("stats", "hoursPlayed");
            }
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }

    public ArrayList<GameAchievement> getAchievements() {
        if (this.achievements == null) {
            this.achievements = new ArrayList();
            this.achievementsDone = 0;
            for (XMLData achievementData : this.xmlData.getElements("achievements", "achievement")) {
                GameAchievement achievement = new GameAchievement(this.user, this.game, achievementData);
                if (achievement.isUnlocked()) {
                    ++this.achievementsDone;
                }
                this.achievements.add(achievement);
            }
        }
        return this.achievements;
    }

    public int getAchievementsDone() {
        if (this.achievements == null) {
            this.getAchievements();
        }
        return this.achievementsDone;
    }

    public float getAchievementsPercentage() {
        return (float)this.getAchievementsDone() / (float)this.achievements.size();
    }

    public String getBaseUrl() {
        return GameStats.getBaseUrl(this.user.getId(), this.game.getId());
    }

    public SteamGame getGame() {
        return this.game;
    }

    public String getPrivacyState() {
        return this.privacyState;
    }

    public String getHoursPlayed() {
        return this.hoursPlayed;
    }

    public SteamId getUser() {
        return this.user;
    }

    protected boolean isPublic() {
        return this.privacyState.equals("public");
    }
}

