/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.GameLeaderboard;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteamGame {
    private static Map<Integer, SteamGame> games = new HashMap<Integer, SteamGame>();
    private int appId;
    private String iconUrl;
    private String logoHash;
    private String name;
    private String shortName;

    public static void clearCache() {
        games.clear();
    }

    public static boolean checkSteamInf(String path) throws IOException, JSONException, SteamCondenserException {
        BufferedReader steamInf = new BufferedReader(new FileReader(path));
        String steamInfContents = "";
        while (steamInf.ready()) {
            steamInfContents = steamInfContents + steamInf.readLine() + "\n";
        }
        steamInf.close();
        Pattern appIdPattern = Pattern.compile("^\\s*appID=(\\d+)\\s*$", 10);
        Matcher appIdMatcher = appIdPattern.matcher(steamInfContents);
        Pattern versionPattern = Pattern.compile("^\\s*PatchVersion=([\\d\\.]+)\\s*$", 10);
        Matcher versionMatcher = versionPattern.matcher(steamInfContents);
        if (!appIdMatcher.find() || !versionMatcher.find()) {
            throw new SteamCondenserException("The steam.inf file at \"" + path + "\" is invalid.");
        }
        int appId = Integer.parseInt(appIdMatcher.group(1));
        int version = Integer.parseInt(versionMatcher.group(1).replace(".", ""));
        return SteamGame.isUpToDate(appId, version);
    }

    public static SteamGame create(int appId, XMLData gameData) {
        if (games.containsKey(appId)) {
            return games.get(appId);
        }
        return new SteamGame(appId, gameData);
    }

    public static boolean isUpToDate(int appId, int version) throws JSONException, SteamCondenserException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appid", appId);
        params.put("version", version);
        String json = WebApi.getJSON("ISteamApps", "UpToDateCheck", 1, params);
        JSONObject result = new JSONObject(json).getJSONObject("response");
        if (!result.getBoolean("success")) {
            throw new SteamCondenserException(result.getString("error"));
        }
        return result.getBoolean("up_to_date");
    }

    private SteamGame(int appId, XMLData gameData) {
        Matcher matcher;
        Pattern regex;
        String logoUrl;
        this.appId = appId;
        if (gameData.hasElement("name")) {
            logoUrl = gameData.getString("logo");
            this.name = gameData.getString("name");
            if (gameData.hasElement("globalStatsLink")) {
                regex = Pattern.compile("http://steamcommunity.com/stats/([^?/]+)/achievements/");
                matcher = regex.matcher(gameData.getString("globalStatsLink"));
                matcher.find();
                this.shortName = matcher.group(1).toLowerCase();
                this.shortName = matcher.group(1).toLowerCase();
            } else {
                this.shortName = null;
            }
        } else {
            this.iconUrl = gameData.getString("gameIcon");
            logoUrl = gameData.getString("gameLogo");
            this.name = gameData.getString("gameName");
            this.shortName = gameData.getString("gameFriendlyName").toLowerCase();
        }
        regex = Pattern.compile("/" + appId + "/([0-9a-f]+).jpg");
        matcher = regex.matcher(logoUrl);
        if (matcher.find()) {
            this.logoHash = matcher.group(1).toLowerCase();
        }
        games.put(appId, this);
    }

    public int getAppId() {
        return this.appId;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Object getId() {
        if (String.valueOf(this.appId).equals(this.shortName)) {
            return this.appId;
        }
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public GameLeaderboard getLeaderboard(int id) throws SteamCondenserException {
        return GameLeaderboard.getLeaderboard(this.shortName, id);
    }

    public GameLeaderboard getLeaderboard(String name) throws SteamCondenserException {
        return GameLeaderboard.getLeaderboard(this.shortName, name);
    }

    public Map<Integer, GameLeaderboard> getLeaderboards() throws SteamCondenserException {
        return GameLeaderboard.getLeaderboards(this.shortName);
    }

    public String getLogoUrl() {
        if (this.logoHash == null) {
            return null;
        }
        return "http://media.steampowered.com/steamcommunity/public/images/apps/" + this.appId + "/" + this.logoHash + ".jpg";
    }

    public String getLogoThumbnailUrl() {
        if (this.logoHash == null) {
            return null;
        }
        return "http://media.steampowered.com/steamcommunity/public/images/apps/" + this.appId + "/" + this.logoHash + "_thumb.jpg";
    }

    public int getPlayerCount() throws JSONException, WebApiException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appid", this.appId);
        String jsonString = WebApi.getJSON("ISteamUserStats", "GetNumberOfCurrentPlayers", 1, params);
        JSONObject result = new JSONObject(jsonString).getJSONObject("response");
        return result.getInt("player_count");
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getStoreUrl() {
        return "http://store.steampowered.com/app/" + this.appId;
    }

    public GameStats getUserStats(Object steamId) throws SteamCondenserException {
        if (!this.hasStats()) {
            return null;
        }
        return GameStats.createGameStats(steamId, this.shortName);
    }

    public boolean hasStats() {
        return this.shortName != null;
    }

    public boolean isUpToDate(int version) throws JSONException, SteamCondenserException {
        return SteamGame.isUpToDate(this.appId, version);
    }
}

