/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteamGroup {
    private static final String AVATAR_URL = "http://media.steampowered.com/steamcommunity/public/images/avatars/%s/%s%s.jpg";
    protected static Map<Object, SteamGroup> steamGroups = new HashMap<Object, SteamGroup>();
    private String avatarHash;
    private String customUrl;
    private long fetchTime;
    private long groupId64;
    private String headline;
    private Integer memberCount;
    private ArrayList<SteamId> members;
    private String name;
    private String summary;

    public static void clearCache() {
        steamGroups.clear();
    }

    public static SteamGroup create(long id) throws SteamCondenserException {
        return SteamGroup.create((Object)id, true, false);
    }

    public static SteamGroup create(String id) throws SteamCondenserException {
        return SteamGroup.create((Object)id, true, false);
    }

    public static SteamGroup create(long id, boolean fetch) throws SteamCondenserException {
        return SteamGroup.create((Object)id, fetch, false);
    }

    public static SteamGroup create(String id, boolean fetch) throws SteamCondenserException {
        return SteamGroup.create((Object)id, fetch, false);
    }

    public static SteamGroup create(long id, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        return SteamGroup.create((Object)id, fetch, bypassCache);
    }

    public static SteamGroup create(String id, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        return SteamGroup.create((Object)id, fetch, bypassCache);
    }

    private static SteamGroup create(Object id, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        SteamGroup group;
        if (SteamGroup.isCached(id) && !bypassCache) {
            group = steamGroups.get(id);
            if (fetch && !group.isFetched()) {
                group.fetchMembers();
            }
        } else {
            group = new SteamGroup(id, fetch);
            group.cache();
        }
        return group;
    }

    public static boolean isCached(Object id) {
        return steamGroups.containsKey(id);
    }

    protected SteamGroup(Object id, boolean fetch) throws SteamCondenserException {
        if (id instanceof String) {
            this.customUrl = (String)id;
        } else {
            this.groupId64 = (Long)id;
        }
        this.members = new ArrayList();
        if (fetch) {
            this.fetchMembers();
        }
    }

    public boolean cache() {
        if (!steamGroups.containsKey(this.groupId64)) {
            steamGroups.put(this.groupId64, this);
            if (this.customUrl != null && !steamGroups.containsKey(this.customUrl)) {
                steamGroups.put(this.customUrl, this);
            }
            return true;
        }
        return false;
    }

    public void fetchMembers() throws SteamCondenserException {
        int page = this.memberCount == null || this.members.size() != this.memberCount.intValue() ? 0 : 1;
        try {
            int totalPages;
            while (++page < (totalPages = this.fetchPage(page))) {
            }
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
        this.fetchTime = new Date().getTime();
    }

    public String getAvatarFullUrl() {
        return String.format(AVATAR_URL, this.avatarHash.substring(0, 2), this.avatarHash, "_full");
    }

    public String getAvatarIconUrl() {
        return String.format(AVATAR_URL, this.avatarHash.substring(0, 2), this.avatarHash, "");
    }

    public String getAvatarMediumUrl() {
        return String.format(AVATAR_URL, this.avatarHash.substring(0, 2), this.avatarHash, "_medium");
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public long getGroupId64() {
        return this.groupId64;
    }

    public String getBaseUrl() {
        if (this.customUrl == null) {
            return "http://steamcommunity.com/gid/" + this.groupId64;
        }
        return "http://steamcommunity.com/groups/" + this.customUrl;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public String getHeadline() {
        return this.headline;
    }

    public long getId() {
        return this.groupId64;
    }

    public int getMemberCount() throws SteamCondenserException {
        try {
            int totalPages;
            if (this.memberCount == null && (totalPages = this.fetchPage(1)) == 1) {
                this.fetchTime = new Date().getTime();
            }
            return this.memberCount;
        }
        catch (Exception e) {
            throw new SteamCondenserException(e.getMessage(), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    private int fetchPage(int page) throws SteamCondenserException {
        int totalPages;
        try {
            XMLData memberData = new XMLData(this.getBaseUrl() + "/memberslistxml?p=" + page);
            if (page == 1) {
                XMLData groupDetails = memberData.getElement("groupDetails");
                Matcher matcher = Pattern.compile("/([0-9a-f]+)\\.jpg$").matcher(groupDetails.getString("avatarIcon"));
                matcher.find();
                this.avatarHash = matcher.group(1);
                this.customUrl = groupDetails.getString("groupURL");
                this.groupId64 = memberData.getLong("groupID64");
                this.name = groupDetails.getString("groupName");
                this.headline = groupDetails.getString("headline");
                this.summary = groupDetails.getString("summary");
            }
            this.memberCount = memberData.getInteger("memberCount");
            totalPages = memberData.getInteger("totalPages");
            for (XMLData member : memberData.getElements("members", "steamID64")) {
                this.members.add(SteamId.create(member.getLong(new String[0]), false));
            }
        }
        catch (Exception e) {
            if (e instanceof SteamCondenserException) {
                throw (SteamCondenserException)e;
            }
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
        return totalPages;
    }

    public ArrayList<SteamId> getMembers() throws SteamCondenserException {
        if (this.members.size() != this.memberCount.intValue()) {
            this.fetchMembers();
        }
        return this.members;
    }

    public boolean isFetched() {
        return this.fetchTime != 0L;
    }
}

