/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.SteamGame;
import com.github.koraktor.steamcondenser.steam.community.SteamGroup;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteamId {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(1, Locale.ENGLISH);
    private static Map<Object, SteamId> steamIds = new HashMap<Object, SteamId>();
    private String customUrl;
    private long fetchTime;
    private SteamId[] friends;
    private HashMap<Integer, SteamGame> games;
    private SteamGroup[] groups;
    private String headLine;
    private float hoursPlayed;
    private String imageUrl;
    private boolean limitedAccount;
    private Map<String, String> links;
    private String location;
    private Date memberSince;
    private Map<String, Float> mostPlayedGames;
    private String onlineState;
    private Map<Integer, int[]> playtimes;
    private String privacyState;
    private String realName;
    private String stateMessage;
    private String nickname;
    private long steamId64;
    private float steamRating;
    private String summary;
    private String tradeBanState;
    private boolean vacBanned;
    private int visibilityState;

    public static void clearCache() {
        steamIds.clear();
    }

    public static String convertCommunityIdToSteamId(long communityId) throws SteamCondenserException {
        long steamId1 = communityId % 2L;
        long steamId2 = communityId - 0x110000100000000L;
        if (steamId2 <= 0L) {
            throw new SteamCondenserException("SteamID " + communityId + " is too small.");
        }
        steamId2 = (steamId2 - steamId1) / 2L;
        return "STEAM_0:" + steamId1 + ":" + steamId2;
    }

    public static long convertSteamIdToCommunityId(String steamId) throws SteamCondenserException {
        if (steamId.equals("STEAM_ID_LAN") || steamId.equals("BOT")) {
            throw new SteamCondenserException("Cannot convert SteamID \"" + steamId + "\" to a community ID.");
        }
        if (steamId.matches("^STEAM_[0-1]:[0-1]:[0-9]+$")) {
            String[] tmpId = steamId.substring(8).split(":");
            return Long.valueOf(tmpId[0]) + Long.valueOf(tmpId[1]) * 2L + 0x110000100000000L;
        }
        if (steamId.matches("^\\[U:[0-1]:[0-9]+\\]+$")) {
            String[] tmpId = steamId.substring(3, steamId.length() - 1).split(":");
            return Long.valueOf(tmpId[0]) + Long.valueOf(tmpId[1]) + 0x1100000FFFFFFFFL;
        }
        throw new SteamCondenserException("SteamID \"" + steamId + "\" doesn't have the correct format.");
    }

    public static SteamId create(long id) throws SteamCondenserException {
        return SteamId.create((Object)id, true, false);
    }

    public static SteamId create(String id) throws SteamCondenserException {
        return SteamId.create((Object)id, true, false);
    }

    public static SteamId create(long id, boolean fetch) throws SteamCondenserException {
        return SteamId.create((Object)id, fetch, false);
    }

    public static SteamId create(String id, boolean fetch) throws SteamCondenserException {
        return SteamId.create((Object)id, fetch, false);
    }

    public static SteamId create(long id, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        return SteamId.create((Object)id, fetch, bypassCache);
    }

    public static SteamId create(String id, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        return SteamId.create((Object)id, fetch, bypassCache);
    }

    private static SteamId create(Object id, boolean fetch, boolean bypassCache) throws SteamCondenserException {
        if (SteamId.isCached(id) && !bypassCache) {
            SteamId steamId = steamIds.get(id);
            if (fetch && !steamId.isFetched()) {
                steamId.fetchData();
            }
            return steamId;
        }
        return new SteamId(id, fetch);
    }

    public static boolean isCached(Object id) {
        return steamIds.containsKey(id);
    }

    public static Long resolveVanityUrl(String vanityUrl) throws WebApiException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("vanityurl", vanityUrl);
            String json = WebApi.getJSON("ISteamUser", "ResolveVanityURL", 1, params);
            JSONObject result = new JSONObject(json).getJSONObject("response");
            if (result.getInt("success") != 1) {
                return null;
            }
            return Long.parseLong(result.getString("steamid"));
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
    }

    private SteamId(Object id, boolean fetchData) throws SteamCondenserException {
        if (id instanceof String) {
            this.customUrl = (String)id;
        } else {
            this.steamId64 = (Long)id;
        }
        if (fetchData) {
            this.fetchData();
        }
        this.cache();
    }

    public boolean cache() {
        if (!steamIds.containsKey(this.steamId64)) {
            steamIds.put(this.steamId64, this);
            if (this.customUrl != null && !steamIds.containsKey(this.customUrl)) {
                steamIds.put(this.customUrl, this);
            }
            return true;
        }
        return false;
    }

    public void fetchData() throws SteamCondenserException {
        block11: {
            try {
                XMLData profile = new XMLData(this.getBaseUrl() + "?xml=1");
                if (profile.hasElement("error")) {
                    throw new SteamCondenserException(profile.getString("error"));
                }
                this.nickname = profile.getUnescapedString("steamID");
                this.steamId64 = profile.getLong("steamID64");
                this.tradeBanState = profile.getUnescapedString("tradeBanState");
                this.vacBanned = profile.getString("vacBanned").equals("1");
                if (profile.hasElement("privacyMessage")) {
                    throw new SteamCondenserException(profile.getString("privacyMessage"));
                }
                String avatarIconUrl = profile.getString("avatarIcon");
                this.imageUrl = avatarIconUrl.substring(0, avatarIconUrl.length() - 4);
                this.limitedAccount = profile.getString("isLimitedAccount").equals("1");
                this.onlineState = profile.getString("onlineState");
                this.privacyState = profile.getString("privacyState");
                this.stateMessage = profile.getString("stateMessage");
                this.visibilityState = profile.getInteger("visibilityState");
                if (this.privacyState.compareTo("public") != 0) break block11;
                this.customUrl = profile.getString("customURL");
                if (this.customUrl.length() == 0) {
                    this.customUrl = null;
                }
                this.headLine = profile.getUnescapedString("headline");
                this.hoursPlayed = profile.getFloat("hoursPlayed2Wk").floatValue();
                this.location = profile.getString("location");
                String memberSince = profile.getString("memberSince");
                memberSince = memberSince.replaceAll("(\\d+)st|nd|rd|th", "$1");
                try {
                    this.memberSince = DATE_FORMAT.parse(memberSince);
                }
                catch (ParseException e) {
                    this.memberSince = DATE_FORMAT.parse(memberSince + ", " + Calendar.getInstance().get(1));
                }
                this.realName = profile.getUnescapedString("realname");
                this.steamRating = profile.getFloat("steamRating").floatValue();
                this.summary = profile.getUnescapedString("summary");
                this.mostPlayedGames = new HashMap<String, Float>();
                for (XMLData mostPlayedGame : profile.getElements("mostPlayedGames", "mostPlayedGame")) {
                    this.mostPlayedGames.put(mostPlayedGame.getString("gameName"), mostPlayedGame.getFloat("hoursPlayed"));
                }
                List<XMLData> groupElements = profile.getElements("groups", "group");
                this.groups = new SteamGroup[groupElements.size()];
                for (int i = 0; i < this.groups.length; ++i) {
                    XMLData group = groupElements.get(i);
                    this.groups[i] = SteamGroup.create(group.getLong("groupID64"), false);
                }
                this.links = new HashMap<String, String>();
                for (XMLData weblink : profile.getElements("weblinks", "weblink")) {
                    this.links.put(weblink.getUnescapedString("title"), weblink.getString("link"));
                }
            }
            catch (Exception e) {
                if (e instanceof SteamCondenserException) {
                    throw (SteamCondenserException)e;
                }
                throw new SteamCondenserException("XML data could not be parsed.", e);
            }
        }
        this.fetchTime = new Date().getTime();
    }

    private void fetchFriends() throws SteamCondenserException {
        try {
            String url = this.getBaseUrl() + "/friends?xml=1";
            List<XMLData> friendElements = new XMLData(url).getElements("friends", "friend");
            this.friends = new SteamId[friendElements.size()];
            for (int i = 0; i < this.friends.length; ++i) {
                XMLData friend = friendElements.get(i);
                this.friends[i] = SteamId.create(Long.parseLong(friend.getRoot().getTextContent()), false);
            }
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }

    private void fetchGames() throws SteamCondenserException {
        try {
            XMLData gamesData = new XMLData(this.getBaseUrl() + "/games?xml=1");
            this.games = new HashMap();
            this.playtimes = new HashMap<Integer, int[]>();
            for (XMLData gameData : gamesData.getElements("games", "game")) {
                float total;
                float recent;
                int appId = gameData.getInteger("appID");
                SteamGame game = SteamGame.create(appId, gameData);
                this.games.put(appId, game);
                try {
                    recent = gameData.getFloat("hoursLast2Weeks").floatValue();
                }
                catch (NullPointerException e) {
                    recent = 0.0f;
                }
                try {
                    total = gameData.getFloat("hoursOnRecord").floatValue();
                }
                catch (NullPointerException e) {
                    total = 0.0f;
                }
                int[] playtimes = new int[]{(int)(recent * 60.0f), (int)(total * 60.0f)};
                this.playtimes.put(game.getAppId(), playtimes);
            }
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed.", e);
        }
    }

    public String getAvatarFullUrl() {
        return this.imageUrl + "_full.jpg";
    }

    public String getAvatarIconUrl() {
        return this.imageUrl + ".jpg";
    }

    public String getAvatarMediumUrl() {
        return this.imageUrl + "_medium.jpg";
    }

    public String getBaseUrl() {
        if (this.customUrl == null) {
            return "http://steamcommunity.com/profiles/" + this.steamId64;
        }
        return "http://steamcommunity.com/id/" + this.customUrl;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public SteamId[] getFriends() throws SteamCondenserException {
        if (this.friends == null) {
            this.fetchFriends();
        }
        return this.friends;
    }

    public HashMap<Integer, SteamGame> getGames() throws SteamCondenserException {
        if (this.games == null) {
            this.fetchGames();
        }
        return this.games;
    }

    public GameStats getGameStats(Object id) throws SteamCondenserException {
        SteamGame game = this.findGame(id);
        if (!game.hasStats()) {
            throw new SteamCondenserException("\"" + game.getName() + "\" does not have stats.");
        }
        if (this.customUrl == null) {
            return GameStats.createGameStats(this.steamId64, game.getShortName());
        }
        return GameStats.createGameStats(this.customUrl, game.getShortName());
    }

    public SteamGroup[] getGroups() {
        return this.groups;
    }

    public String getHeadLine() {
        return this.headLine;
    }

    public float getHoursPlayed() {
        return this.hoursPlayed;
    }

    public Object getId() {
        return this.customUrl == null ? Long.valueOf(this.steamId64) : this.customUrl;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public String getLocation() {
        return this.location;
    }

    public Date getMemberSince() {
        return this.memberSince;
    }

    public Map<String, Float> getMostPlayedGames() {
        return this.mostPlayedGames;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPrivacyState() {
        return this.privacyState;
    }

    public String getRealName() {
        return this.realName;
    }

    public int getRecentPlaytime(Object id) throws SteamCondenserException {
        SteamGame game = this.findGame(id);
        return this.playtimes.get(game.getAppId())[0];
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public long getSteamId64() {
        return this.steamId64;
    }

    public float getSteamRating() {
        return this.steamRating;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getTotalPlaytime(Object id) throws SteamCondenserException {
        SteamGame game = this.findGame(id);
        return this.playtimes.get(game.getAppId())[1];
    }

    public String getTradeBanState() {
        return this.tradeBanState;
    }

    public int getVisibilityState() {
        return this.visibilityState;
    }

    private SteamGame findGame(Object id) throws SteamCondenserException {
        SteamGame game = null;
        if (id instanceof Integer) {
            game = this.getGames().get(id);
        } else {
            for (SteamGame currentGame : this.getGames().values()) {
                if (!id.equals(currentGame.getShortName()) && !id.equals(currentGame.getName())) continue;
                game = currentGame;
                break;
            }
        }
        if (game == null) {
            String message = id instanceof Integer ? "This SteamID does not own a game with application ID " + id + "." : "This SteamID does not own the game \"" + id + "\".";
            throw new SteamCondenserException(message);
        }
        return game;
    }

    public boolean isBanned() {
        return this.vacBanned;
    }

    public boolean isFetched() {
        return this.fetchTime != 0L;
    }

    public boolean isInGame() {
        return this.onlineState.equals("in-game");
    }

    public boolean isLimitedAccount() {
        return this.limitedAccount;
    }

    public boolean isOnline() {
        return this.onlineState.equals("online") || this.onlineState.equals("in-game");
    }
}

