/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebApi {
    protected static final Logger LOG = Logger.getLogger(WebApi.class.getName());
    protected static String apiKey;
    protected static boolean secure;

    public static String getApiKey() {
        return apiKey;
    }

    public static JSONArray getInterfaces() throws JSONException, WebApiException {
        String data = WebApi.getJSON("ISteamWebAPIUtil", "GetSupportedAPIList");
        return new JSONObject(data).getJSONObject("apilist").getJSONArray("interfaces");
    }

    public static void setApiKey(String apiKey) throws WebApiException {
        if (apiKey != null && !apiKey.matches("^[0-9A-F]{32}$")) {
            throw new WebApiException(WebApiException.Cause.INVALID_KEY);
        }
        WebApi.apiKey = apiKey;
    }

    public static void setSecure(boolean secure) {
        WebApi.secure = secure;
    }

    public static String getJSON(String apiInterface, String method) throws WebApiException {
        return WebApi.load("json", apiInterface, method, 1, null);
    }

    public static String getJSON(String apiInterface, String method, int version) throws WebApiException {
        return WebApi.load("json", apiInterface, method, version, null);
    }

    public static String getJSON(String apiInterface, String method, int version, Map<String, Object> params) throws WebApiException {
        return WebApi.load("json", apiInterface, method, version, params);
    }

    public static JSONObject getJSONData(String apiInterface, String method) throws JSONException, WebApiException {
        return WebApi.getJSONData(apiInterface, method, 1, null);
    }

    public static JSONObject getJSONData(String apiInterface, String method, int version) throws JSONException, WebApiException {
        return WebApi.getJSONData(apiInterface, method, version, null);
    }

    public static JSONObject getJSONData(String apiInterface, String method, int version, Map<String, Object> params) throws JSONException, WebApiException {
        String data = WebApi.getJSON(apiInterface, method, version, params);
        JSONObject result = new JSONObject(data).getJSONObject("result");
        if (result.getInt("status") != 1) {
            throw new WebApiException(WebApiException.Cause.STATUS_BAD, result.getInt("status"), result.getString("statusDetail"));
        }
        return result;
    }

    public static String load(String format, String apiInterface, String method) throws WebApiException {
        return WebApi.load(format, apiInterface, method, 1, null);
    }

    public static String load(String format, String apiInterface, String method, int version) throws WebApiException {
        return WebApi.load(format, apiInterface, method, version, null);
    }

    public static String load(String format, String apiInterface, String method, int version, Map<String, Object> params) throws WebApiException {
        String data;
        String protocol = secure ? "https" : "http";
        String url = String.format("%s://api.steampowered.com/%s/%s/v%04d/?", protocol, apiInterface, method, version);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("format", format);
        if (apiKey != null) {
            params.put("key", apiKey);
        }
        boolean first = true;
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                url = url + '&';
            }
            url = url + String.format("%s=%s", param.getKey(), param.getValue());
        }
        if (LOG.isLoggable(Level.INFO)) {
            String debugUrl = apiKey == null ? url : url.replace(apiKey, "SECRET");
            LOG.info("Querying Steam Web API: " + debugUrl);
        }
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpClient.getParams().setBooleanParameter("http.protocol.handle-authentication", false);
            HttpGet request = new HttpGet(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            Integer statusCode = response.getStatusLine().getStatusCode();
            if (!statusCode.toString().startsWith("20")) {
                if (statusCode == 401) {
                    throw new WebApiException(WebApiException.Cause.UNAUTHORIZED);
                }
                throw new WebApiException(WebApiException.Cause.HTTP_ERROR, statusCode, response.getStatusLine().getReasonPhrase());
            }
            data = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (WebApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApiException("Could not communicate with the Web API.", e);
        }
        return data;
    }

    static {
        secure = true;
    }
}

