/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLData {
    protected static DocumentBuilder documentBuilder;
    protected static XPath xpath;
    protected Element root;

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (documentBuilder == null) {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        return documentBuilder;
    }

    public XMLData(String url) throws SteamCondenserException {
        try {
            this.root = XMLData.getDocumentBuilder().parse(url).getDocumentElement();
        }
        catch (Exception e) {
            throw new SteamCondenserException("XML data could not be parsed: " + e.getMessage(), e);
        }
    }

    protected XMLData(Element element) {
        this.root = element;
    }

    public static void setDocumentBuilder(DocumentBuilder documentBuilder) {
        XMLData.documentBuilder = documentBuilder;
    }

    public String getAttribute(String name) {
        return this.root.getAttribute(name);
    }

    public List<XMLData> getChildren(String ... names) {
        return this.wrapNodeList(this.getElement(names).getRoot().getChildNodes());
    }

    public XMLData getElement(String ... names) {
        Element node = this.root;
        for (String name : names) {
            if (node.getElementsByTagName(name).getLength() == 0) {
                return null;
            }
            node = (Element)node.getElementsByTagName(name).item(0);
        }
        return new XMLData(node);
    }

    public XMLData getXPath(String path) {
        if (xpath == null) {
            xpath = XPathFactory.newInstance().newXPath();
        }
        try {
            return new XMLData((Element)xpath.evaluate(path, this.root, XPathConstants.NODE));
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public List<XMLData> getElements(String ... names) {
        String name = names[names.length - 1];
        String[] baseNames = new String[names.length - 1];
        System.arraycopy(names, 0, baseNames, 0, names.length - 1);
        XMLData baseElement = this.getElement(baseNames);
        if (baseElement == null) {
            return new ArrayList<XMLData>();
        }
        return this.wrapNodeList(baseElement.getRoot().getElementsByTagName(name));
    }

    public Float getFloat(String ... names) {
        String value = this.getString(names).replaceAll(",", "").trim();
        return Float.valueOf(value.isEmpty() ? 0.0f : Float.parseFloat(value));
    }

    public Integer getInteger(String ... names) {
        String value = this.getString(names).trim();
        return value.isEmpty() ? 0 : Integer.parseInt(value);
    }

    public Long getLong(String ... names) {
        String value = this.getString(names).trim();
        return value.isEmpty() ? 0L : Long.parseLong(value);
    }

    public String getName() {
        return this.root.getTagName();
    }

    public Element getRoot() {
        return this.root;
    }

    public String getString(String ... names) {
        Element element = this.getElement(names).getRoot();
        if (element == null) {
            return null;
        }
        return element.getTextContent();
    }

    public String getUnescapedString(String ... names) {
        return StringEscapeUtils.unescapeXml((String)this.getString(names));
    }

    public boolean hasElement(String ... names) {
        return this.getElement(names) != null;
    }

    protected List<XMLData> wrapNodeList(NodeList nodeList) {
        ArrayList<XMLData> elements = new ArrayList<XMLData>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(new XMLData((Element)nodeList.item(i)));
        }
        return elements;
    }
}

