/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.alien_swarm;

import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlienSwarmMission {
    private float avgDamageTaken;
    private float avgFriendlyFire;
    private float avgKills;
    private String bestDifficulty;
    private int damageTaken;
    private int friendlyFire;
    private int gamesSuccessful;
    private String img;
    private int kills;
    private String mapName;
    private String name;
    private Map<String, String> time;
    private int totalGames;
    private float totalGamesPercentage;

    public AlienSwarmMission(XMLData missionData) {
        this.avgDamageTaken = missionData.getFloat("damagetakenavg").floatValue();
        this.avgFriendlyFire = missionData.getFloat("friendlyfireavg").floatValue();
        this.avgKills = missionData.getFloat("killsavg").floatValue();
        this.bestDifficulty = missionData.getString("bestdifficulty");
        this.damageTaken = missionData.getInteger("damagetaken");
        this.friendlyFire = missionData.getInteger("friendlyfire");
        this.gamesSuccessful = missionData.getInteger("gamessuccess");
        this.img = "http://steamcommunity.com/public/images/gamestats/swarm/" + missionData.getString("image");
        this.kills = missionData.getInteger("kills");
        this.mapName = missionData.getName();
        this.name = missionData.getString("name");
        this.totalGames = missionData.getInteger("gamestotal");
        this.totalGamesPercentage = missionData.getFloat("gamestotalpct").floatValue();
        this.time = new HashMap<String, String>();
        this.time.put("average", missionData.getString("avgtime"));
        this.time.put("brutal", missionData.getString("brutaltime"));
        this.time.put("easy", missionData.getString("easytime"));
        this.time.put("hard", missionData.getString("hardtime"));
        this.time.put("insane", missionData.getString("insanetime"));
        this.time.put("normal", missionData.getString("normaltime"));
        this.time.put("total", missionData.getString("totaltime"));
    }

    public float getAvgDamageTaken() {
        return this.avgDamageTaken;
    }

    public float getAvgFriendlyFire() {
        return this.avgFriendlyFire;
    }

    public float getAvgKills() {
        return this.avgKills;
    }

    public String getBestDifficulty() {
        return this.bestDifficulty;
    }

    public int getDamageTaken() {
        return this.damageTaken;
    }

    public int getFriendlyFire() {
        return this.friendlyFire;
    }

    public int getGamesSuccessful() {
        return this.gamesSuccessful;
    }

    public String getImg() {
        return this.img;
    }

    public int getKills() {
        return this.kills;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTime() {
        return this.time;
    }

    public int getTotalGames() {
        return this.totalGames;
    }

    public float getTotalGamesPercentage() {
        return this.totalGamesPercentage;
    }
}

