/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.css;

import com.github.koraktor.steamcondenser.steam.community.XMLData;

public class CSSMap {
    private boolean favorite;
    private String name;
    private int roundsPlayed;
    private int roundsLost;
    private int roundsWon;

    public CSSMap(String mapName, XMLData mapsData) {
        this.name = mapName;
        this.favorite = mapsData.getString("favorite").equals(this.name);
        this.roundsPlayed = mapsData.getInteger(this.name + "_rounds");
        this.roundsWon = mapsData.getInteger(this.name + "_wins");
        this.roundsLost = this.roundsPlayed - this.roundsWon;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public String getName() {
        return this.name;
    }

    public int getRoundsLost() {
        return this.roundsLost;
    }

    public int getRoundsPlayed() {
        return this.roundsPlayed;
    }

    public int getRoundsWon() {
        return this.roundsWon;
    }

    public float getRoundsWonPercentage() {
        return this.roundsPlayed > 0 ? (float)(this.roundsWon / this.roundsPlayed) : 0.0f;
    }
}

