/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.css;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.css.CSSMap;
import com.github.koraktor.steamcondenser.steam.community.css.CSSWeapon;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStats
extends GameStats {
    private static final String[] MAPS = new String[]{"cs_assault", "cs_compound", "cs_havana", "cs_italy", "cs_militia", "cs_office", "de_aztec", "de_cbble", "de_chateau", "de_dust", "de_dust2", "de_inferno", "de_nuke", "de_piranesi", "de_port", "de_prodigy", "de_tides", "de_train"};
    private static final String[] WEAPONS = new String[]{"deagle", "usp", "glock", "p228", "elite", "fiveseven", "awp", "ak47", "m4a1", "aug", "sg552", "sg550", "galil", "famas", "scout", "g3sg1", "p90", "mp5navy", "tmp", "mac10", "ump45", "m3", "xm1014", "m249", "knife", "grenade"};
    private Map<String, Object> lastMatchStats;
    private Map<String, CSSMap> mapStats;
    private Map<String, Object> totalStats;
    private Map<String, CSSWeapon> weaponStats;

    public CSSStats(Object steamId) throws SteamCondenserException {
        super(steamId, "cs:s");
        if (this.isPublic()) {
            // empty if block
        }
        XMLData lastMatchStats = this.xmlData.getElement("stats", "lastmatch");
        XMLData lifetimeStats = this.xmlData.getElement("stats", "lifetime");
        XMLData summaryStats = this.xmlData.getElement("stats", "summary");
        this.lastMatchStats = new HashMap<String, Object>();
        this.totalStats = new HashMap<String, Object>();
        this.lastMatchStats.put("costPerKill", lastMatchStats.getFloat("costkill"));
        this.lastMatchStats.put("ctWins", lastMatchStats.getInteger("ct_wins"));
        this.lastMatchStats.put("damage", lastMatchStats.getInteger("dmg"));
        this.lastMatchStats.put("deaths", lastMatchStats.getInteger("deaths"));
        this.lastMatchStats.put("dominations", lastMatchStats.getInteger("dominations"));
        this.lastMatchStats.put("favoriteWeaponId", lastMatchStats.getInteger("favwpnid"));
        this.lastMatchStats.put("kills", lastMatchStats.getInteger("kills"));
        this.lastMatchStats.put("maxPlayers", lastMatchStats.getInteger("max_players"));
        this.lastMatchStats.put("money", lastMatchStats.getInteger("money"));
        this.lastMatchStats.put("revenges", lastMatchStats.getInteger("revenges"));
        this.lastMatchStats.put("stars", lastMatchStats.getInteger("stars"));
        this.lastMatchStats.put("tWins", lastMatchStats.getInteger("t_wins"));
        this.lastMatchStats.put("wins", lastMatchStats.getInteger("wins"));
        this.totalStats.put("blindKills", lifetimeStats.getInteger("blindkills"));
        this.totalStats.put("bombsDefused", lifetimeStats.getInteger("bombsdefused"));
        this.totalStats.put("bombsPlanted", lifetimeStats.getInteger("bombsplanted"));
        this.totalStats.put("damage", lifetimeStats.getInteger("dmg"));
        this.totalStats.put("deaths", summaryStats.getInteger("deaths"));
        this.totalStats.put("dominationOverkills", lifetimeStats.getInteger("dominationoverkills"));
        this.totalStats.put("dominations", lifetimeStats.getInteger("dominations"));
        this.totalStats.put("earnedMoney", lifetimeStats.getInteger("money"));
        this.totalStats.put("enemyWeaponKills", lifetimeStats.getInteger("enemywpnkills"));
        this.totalStats.put("headshots", lifetimeStats.getInteger("headshots"));
        this.totalStats.put("hits", summaryStats.getInteger("shotshit"));
        this.totalStats.put("hostagesRescued", lifetimeStats.getInteger("hostagesrescued"));
        this.totalStats.put("kills", summaryStats.getInteger("kills"));
        this.totalStats.put("knifeKills", lifetimeStats.getInteger("knifekills"));
        this.totalStats.put("logosSprayed", lifetimeStats.getInteger("decals"));
        this.totalStats.put("nightvisionDamage", lifetimeStats.getInteger("nvgdmg"));
        this.totalStats.put("pistolRoundsWon", lifetimeStats.getInteger("pistolrounds"));
        this.totalStats.put("revenges", lifetimeStats.getInteger("revenges"));
        this.totalStats.put("roundsPlayed", summaryStats.getInteger("rounds"));
        this.totalStats.put("roundsWon", summaryStats.getInteger("wins"));
        this.totalStats.put("secondsPlayed", summaryStats.getInteger("timeplayed"));
        this.totalStats.put("shots", summaryStats.getInteger("shots"));
        this.totalStats.put("stars", summaryStats.getInteger("stars"));
        this.totalStats.put("weaponsDonated", lifetimeStats.getInteger("wpndonated"));
        this.totalStats.put("windowsBroken", lifetimeStats.getInteger("winbroken"));
        this.totalStats.put("zoomedSniperKills", lifetimeStats.getInteger("zsniperkills"));
        if ((Integer)this.lastMatchStats.get("deaths") > 0) {
            this.lastMatchStats.put("kdratio", Float.valueOf(((Integer)this.lastMatchStats.get("kills")).floatValue() / (float)((Integer)this.lastMatchStats.get("deaths")).intValue()));
        } else {
            this.lastMatchStats.put("kdratio", 0);
        }
        if ((Integer)this.totalStats.get("shots") > 0) {
            this.totalStats.put("accuracy", Float.valueOf(((Integer)this.totalStats.get("hits")).floatValue() / (float)((Integer)this.totalStats.get("shots")).intValue()));
        } else {
            this.totalStats.put("accuracy", 0);
        }
        if ((Integer)this.totalStats.get("deaths") > 0) {
            this.totalStats.put("kdratio", Float.valueOf(((Integer)this.totalStats.get("kills")).floatValue() / (float)((Integer)this.totalStats.get("deaths")).intValue()));
        } else {
            this.totalStats.put("kdratio", 0);
        }
        this.totalStats.put("roundsLost", Float.valueOf(((Integer)this.totalStats.get("roundsPlayed")).floatValue() - (float)((Integer)this.totalStats.get("roundsWon")).intValue()));
    }

    public Map<String, Object> getLastMatchStats() {
        return this.lastMatchStats;
    }

    public Map<String, CSSMap> getMapStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.mapStats == null) {
            this.mapStats = new HashMap<String, CSSMap>();
            XMLData mapsData = this.xmlData.getElement("stats", "maps");
            for (String mapName : MAPS) {
                this.mapStats.put(mapName, new CSSMap(mapName, mapsData));
            }
        }
        return this.mapStats;
    }

    public Map<String, Object> getTotalStats() {
        return this.totalStats;
    }

    public Map<String, CSSWeapon> getWeaponStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.weaponStats == null) {
            this.weaponStats = new HashMap<String, CSSWeapon>();
            XMLData weaponData = this.xmlData.getElement("stats", "weapons");
            for (String weaponName : WEAPONS) {
                this.weaponStats.put(weaponName, new CSSWeapon(weaponName, weaponData));
            }
        }
        return this.weaponStats;
    }
}

