/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.css;

import com.github.koraktor.steamcondenser.steam.community.XMLData;

public class CSSWeapon {
    private boolean favorite;
    private int hits;
    private int kills;
    private String name;
    private int shots;

    public CSSWeapon(String weaponName, XMLData weaponsData) {
        this.name = weaponName;
        this.favorite = weaponsData.getString("favorite").equals(this.name);
        this.kills = weaponsData.getInteger(this.name + "_kills");
        if (!this.name.equals("grenade") && !this.name.equals("knife")) {
            this.hits = weaponsData.getInteger(this.name + "_hits");
            this.shots = weaponsData.getInteger(this.name + "_shots");
        }
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public float getAccuracy() {
        return this.shots > 0 ? (float)(this.hits / this.shots) : 0.0f;
    }

    public int getHits() {
        return this.hits;
    }

    public int getKills() {
        return this.kills;
    }

    public float getKsRatio() {
        return this.shots > 0 ? (float)(this.kills / this.shots) : 0.0f;
    }

    public String getName() {
        return this.name;
    }

    public int getShots() {
        return this.shots;
    }
}

