/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.defense_grid;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefenseGridStats
extends GameStats {
    private HashMap<String, int[]> alienStats;
    private int bronzeMedals;
    private int silverMedals;
    private int goldMedals;
    private int levelsPlayed;
    private int levelsPlayedCampaign;
    private int levelsPlayedChallenge;
    private int levelsWon;
    private int levelsWonCampaign;
    private int levelsWonChallenge;
    private int encountered;
    private int killed;
    private int killedCampaign;
    private int killedChallenge;
    private float resources;
    private float heatDamage;
    private float timePlayed;
    private float interest;
    private float damage;
    private float damageCampaign;
    private float damageChallenge;
    private int orbitalLaserFired;
    private float orbitalLaserDamage;
    private HashMap<String, ArrayList<float[]>> towerStats;

    public DefenseGridStats(Object steamId) throws SteamCondenserException {
        super(steamId, "defensegrid:awakening");
        if (this.isPublic()) {
            XMLData generalData = this.xmlData.getElement("stats", "general");
            this.bronzeMedals = generalData.getInteger("bronze_medals_won", "value");
            this.silverMedals = generalData.getInteger("silver_medals_won", "value");
            this.goldMedals = generalData.getInteger("gold_medals_won", "value");
            this.levelsPlayed = generalData.getInteger("levels_played_total", "value");
            this.levelsPlayedCampaign = generalData.getInteger("levels_played_campaign", "value");
            this.levelsPlayedChallenge = generalData.getInteger("levels_played_challenge", "value");
            this.levelsWon = generalData.getInteger("levels_won_total", "value");
            this.levelsWonCampaign = generalData.getInteger("levels_won_campaign", "value");
            this.levelsWonChallenge = generalData.getInteger("levels_won_challenge", "value");
            this.encountered = generalData.getInteger("total_aliens_encountered", "value");
            this.killed = generalData.getInteger("total_aliens_killed", "value");
            this.killedCampaign = generalData.getInteger("total_aliens_killed_campaign", "value");
            this.killedChallenge = generalData.getInteger("total_aliens_killed_challenge", "value");
            this.resources = generalData.getFloat("resources_recovered", "value").floatValue();
            this.heatDamage = generalData.getFloat("heatdamage", "value").floatValue();
            this.timePlayed = generalData.getFloat("time_played", "value").floatValue();
            this.interest = generalData.getFloat("interest_gained", "value").floatValue();
            this.damage = generalData.getFloat("tower_damage_total", "value").floatValue();
            this.damageCampaign = generalData.getFloat("tower_damage_total_campaign", "value").floatValue();
            this.damageChallenge = generalData.getFloat("tower_damage_total_challenge", "value").floatValue();
            this.orbitalLaserFired = this.xmlData.getInteger("stats", "orbitallaser", "fired", "value");
            this.orbitalLaserDamage = this.xmlData.getFloat("stats", "orbitallaser", "damage", "value").floatValue();
        }
    }

    public HashMap<String, int[]> getAlienStats() throws SteamCondenserException {
        if (!this.isPublic()) {
            return null;
        }
        if (this.alienStats != null) {
            String[] aliens;
            XMLData aliensData = this.xmlData.getElement("stats", "aliens");
            this.alienStats = new HashMap();
            for (String alien : aliens = new String[]{"bulwark", "crasher", "dart", "decoy", "drone", "grunt", "juggernaut", "manta", "racer", "rumbler", "seeker", "spire", "stealth", "swarmer", "turtle", "walker"}) {
                int[] alienData = new int[]{aliensData.getInteger(alien, "encountered", "value"), aliensData.getInteger(alien, "killed", "value")};
                this.alienStats.put(alien, alienData);
            }
        }
        return this.alienStats;
    }

    public int getBronzeMedals() {
        return this.bronzeMedals;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getDamageCampaign() {
        return this.damageCampaign;
    }

    public float getDamageChallenge() {
        return this.damageChallenge;
    }

    public int getEncountered() {
        return this.encountered;
    }

    public int getGoldMedals() {
        return this.goldMedals;
    }

    public float getHeatDamage() {
        return this.heatDamage;
    }

    public float getInterest() {
        return this.interest;
    }

    public int getKilled() {
        return this.killed;
    }

    public int getKilledCampaign() {
        return this.killedCampaign;
    }

    public int getKilledChallenge() {
        return this.killedChallenge;
    }

    public int getLevelsPlayed() {
        return this.levelsPlayed;
    }

    public int getLevelsPlayedCampaign() {
        return this.levelsPlayedCampaign;
    }

    public int getLevelsPlayedChallenge() {
        return this.levelsPlayedChallenge;
    }

    public int getLevelsWon() {
        return this.levelsWon;
    }

    public int getLevelsWonCampaign() {
        return this.levelsWonCampaign;
    }

    public int getLevelsWonChallenge() {
        return this.levelsWonChallenge;
    }

    public float getOrbitalLaserDamage() {
        return this.orbitalLaserDamage;
    }

    public int getOrbitalLaserFired() {
        return this.orbitalLaserFired;
    }

    public float getResources() {
        return this.resources;
    }

    public int getSilverMedals() {
        return this.silverMedals;
    }

    public float getTimePlayed() {
        return this.timePlayed;
    }

    public HashMap<String, ArrayList<float[]>> getTowerStats() throws SteamCondenserException {
        if (!this.isPublic()) {
            return null;
        }
        if (this.towerStats != null) {
            int i;
            ArrayList<float[]> towerData;
            String[] towers;
            XMLData towersData = this.xmlData.getElement("stats", "towers");
            this.towerStats = new HashMap();
            for (String tower : towers = new String[]{"cannon", "flak", "gun", "inferno", "laser", "meteor", "missile", "tesla"}) {
                towerData = new ArrayList();
                for (int i2 = 1; i2 <= 3; ++i2) {
                    float[] levelData = new float[]{towersData.getXPath(tower + "[@level=" + i2 + "]/built/value").getFloat(new String[0]).floatValue(), towersData.getXPath(tower + "[@level=" + i2 + "]/damage/value").getFloat(new String[0]).floatValue()};
                    towerData.add(i2, levelData);
                }
                this.towerStats.put(tower, towerData);
            }
            towerData = new ArrayList<float[]>();
            for (i = 1; i <= 3; ++i) {
                float[] levelData = new float[]{towersData.getXPath("command[@level=" + i + "]/built/value").getFloat(new String[0]).floatValue(), towersData.getXPath("command[@level=" + i + "]/resource/value").getFloat(new String[0]).floatValue()};
                towerData.add(i, levelData);
            }
            this.towerStats.put("command", towerData);
            towerData = new ArrayList();
            for (i = 1; i <= 3; ++i) {
                float[] levelData = new float[2];
                levelData[0] = towersData.getXPath("temporal[@level=" + i + "]/built/value").getFloat(new String[0]).floatValue();
                towerData.add(i, levelData);
            }
            this.towerStats.put("temporal", towerData);
        }
        return this.towerStats;
    }
}

