/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.dods;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.dods.DoDSClass;
import com.github.koraktor.steamcondenser.steam.community.dods.DoDSWeapon;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoDSStats
extends GameStats {
    private HashMap<String, DoDSClass> classStats;
    private HashMap<String, DoDSWeapon> weaponStats;

    public DoDSStats(Object steamId) throws SteamCondenserException {
        super(steamId, "dod:s");
    }

    public HashMap<String, DoDSClass> getClassStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.classStats == null) {
            this.classStats = new HashMap();
            for (XMLData classData : this.xmlData.getElements("classes", "class")) {
                this.classStats.put(classData.getAttribute("key"), new DoDSClass(classData));
            }
        }
        return this.classStats;
    }

    public HashMap<String, DoDSWeapon> getWeaponStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.weaponStats == null) {
            this.weaponStats = new HashMap();
            for (XMLData weaponData : this.xmlData.getChildren("weapons")) {
                this.weaponStats.put(weaponData.getAttribute("key"), new DoDSWeapon(weaponData));
            }
        }
        return this.weaponStats;
    }
}

