/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.l4d;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.GameWeapon;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractL4DStats
extends GameStats {
    protected HashMap<String, Object> favorites;
    protected HashMap<String, Object> lifetimeStats;
    protected HashMap<String, Object> mostRecentGame;
    protected HashMap<String, Object> survivalStats;
    protected HashMap<String, Object> teamplayStats;
    protected HashMap<String, Object> versusStats;
    protected HashMap<String, GameWeapon> weaponStats;

    public AbstractL4DStats(Object steamId, String gameName) throws SteamCondenserException {
        super(steamId, gameName);
        if (this.isPublic()) {
            XMLData mostRecentGameNode = this.xmlData.getElement("stats", "mostRecentGame");
            this.mostRecentGame = new HashMap();
            if (mostRecentGameNode != null) {
                this.mostRecentGame.put("difficulty", mostRecentGameNode.getString("difficulty"));
                this.mostRecentGame.put("escaped", mostRecentGameNode.getString("bEscaped").equals("1"));
                this.mostRecentGame.put("movie", mostRecentGameNode.getString("movie"));
                this.mostRecentGame.put("timePlayed", mostRecentGameNode.getString("time"));
            }
        }
    }

    public Map<String, Object> getFavorites() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.favorites == null) {
            XMLData favoritesNode = this.xmlData.getElement("stats", "favorites");
            this.favorites = new HashMap();
            this.favorites.put("campaign", favoritesNode.getString("campaign"));
            this.favorites.put("campaignPercentage", favoritesNode.getInteger("campaignpct"));
            this.favorites.put("character", favoritesNode.getString("character"));
            this.favorites.put("characterPercentage", favoritesNode.getInteger("characterpct"));
            this.favorites.put("level1Weapon", favoritesNode.getString("weapon1"));
            this.favorites.put("level1WeaponPercentage", favoritesNode.getInteger("weapon1pct"));
            this.favorites.put("level2Weapon", favoritesNode.getString("weapon2"));
            this.favorites.put("level2WeaponPercentage", favoritesNode.getInteger("weapon2pct"));
        }
        return this.favorites;
    }

    public Map<String, Object> getLifetimeStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.lifetimeStats == null) {
            XMLData lifetimeStatsElement = this.xmlData.getElement("stats", "lifetime");
            this.lifetimeStats = new HashMap();
            this.lifetimeStats.put("finalesSurvived", lifetimeStatsElement.getInteger("finales"));
            this.lifetimeStats.put("gamesPlayed", lifetimeStatsElement.getInteger("gamesplayed"));
            this.lifetimeStats.put("finalesSurvivedPercentage", Float.valueOf(((Integer)this.lifetimeStats.get("finalesSurvived")).floatValue() / (float)((Integer)this.lifetimeStats.get("gamesPlayed")).intValue()));
            this.lifetimeStats.put("infectedKilled", lifetimeStatsElement.getInteger("infectedkilled"));
            this.lifetimeStats.put("killsPerHour", lifetimeStatsElement.getFloat("killsperhour"));
            this.lifetimeStats.put("avgKitsShared", lifetimeStatsElement.getFloat("kitsshared"));
            this.lifetimeStats.put("avgKitsUsed", lifetimeStatsElement.getFloat("kitsused"));
            this.lifetimeStats.put("avgPillsShared", lifetimeStatsElement.getFloat("pillsshared"));
            this.lifetimeStats.put("avgPillsUsed", lifetimeStatsElement.getFloat("pillsused"));
            this.lifetimeStats.put("timePlayed", lifetimeStatsElement.getString("timeplayed"));
        }
        return this.lifetimeStats;
    }

    public Map<String, Object> getSurvivalStats() throws SteamCondenserException {
        if (!this.isPublic()) {
            return null;
        }
        if (this.survivalStats == null) {
            XMLData survivalStatsElement = this.xmlData.getElement("stats", "survival");
            this.survivalStats = new HashMap();
            this.survivalStats.put("goldMedals", survivalStatsElement.getInteger("goldmedals"));
            this.survivalStats.put("silverMedals", survivalStatsElement.getInteger("silvermedals"));
            this.survivalStats.put("bronzeMedals", survivalStatsElement.getInteger("bronzemedals"));
            this.survivalStats.put("roundsPlayed", survivalStatsElement.getInteger("roundsplayed"));
            this.survivalStats.put("bestTime", survivalStatsElement.getFloat("besttime"));
            HashMap<String, L4DMap> mapsHash = new HashMap<String, L4DMap>();
            for (XMLData mapData : survivalStatsElement.getElements("maps")) {
                mapsHash.put(mapData.getName(), new L4DMap(mapData));
            }
            this.survivalStats.put("maps", mapsHash);
        }
        return this.survivalStats;
    }

    public Map<String, Object> getTeamplayStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.teamplayStats == null) {
            XMLData teamplayStatsElement = this.xmlData.getElement("stats", "teamplay");
            this.teamplayStats = new HashMap();
            this.teamplayStats.put("revived", teamplayStatsElement.getInteger("revived"));
            this.teamplayStats.put("mostRevivedDifficulty", teamplayStatsElement.getString("reviveddiff"));
            this.teamplayStats.put("avgRevived", teamplayStatsElement.getFloat("revivedavg"));
            this.teamplayStats.put("avgWasRevived", teamplayStatsElement.getFloat("wasrevivedavg"));
            this.teamplayStats.put("protected", teamplayStatsElement.getInteger("protected"));
            this.teamplayStats.put("mostProtectedDifficulty", teamplayStatsElement.getString("protecteddiff"));
            this.teamplayStats.put("avgProtected", teamplayStatsElement.getFloat("protectedavg"));
            this.teamplayStats.put("avgWasProtected", teamplayStatsElement.getFloat("wasprotectedavg"));
            this.teamplayStats.put("friendlyFireDamage", teamplayStatsElement.getInteger("ffdamage"));
            this.teamplayStats.put("mostFriendlyFireDamageDifficulty", teamplayStatsElement.getString("ffdamagediff"));
            this.teamplayStats.put("avgFriendlyFireDamage", teamplayStatsElement.getFloat("ffdamageavg"));
        }
        return this.teamplayStats;
    }

    public Map<String, Object> getVersusStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.versusStats == null) {
            XMLData versusStatsElement = this.xmlData.getElement("stats", "versus");
            this.versusStats = new HashMap();
            this.versusStats.put("gamesPlayed", versusStatsElement.getInteger("gamesplayed"));
            this.versusStats.put("gamesCompleted", versusStatsElement.getInteger("gamescompleted"));
            this.versusStats.put("finalesSurvived", versusStatsElement.getInteger("finales"));
            this.versusStats.put("finalesSurvivedPercentage", Float.valueOf(((Integer)this.versusStats.get("finalesSurvived")).floatValue() / (float)((Integer)this.versusStats.get("gamesPlayed")).intValue()));
            this.versusStats.put("points", versusStatsElement.getInteger("points"));
            this.versusStats.put("mostPointsInfected", versusStatsElement.getString("pointsas"));
            this.versusStats.put("gamesWon", versusStatsElement.getInteger("gameswon"));
            this.versusStats.put("gamesLost", versusStatsElement.getInteger("gameslost"));
            this.versusStats.put("highestSurvivorScore", versusStatsElement.getInteger("survivorscore"));
            ArrayList<String> infectedArray = new ArrayList<String>();
            infectedArray.add("boomer");
            infectedArray.add("hunter");
            infectedArray.add("smoker");
            infectedArray.add("tank");
            for (String infected : infectedArray) {
                HashMap<String, Integer> infectedStats = new HashMap<String, Integer>();
                infectedStats.put("special", versusStatsElement.getInteger(infected + "special"));
                infectedStats.put("mostDamage", versusStatsElement.getInteger(infected + "dmg"));
                infectedStats.put("avgLifespan", versusStatsElement.getInteger(infected + "lifespan"));
                this.versusStats.put(infected, infectedStats);
            }
        }
        return this.versusStats;
    }
}

