/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.l4d;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DMap;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L4D2Map
extends L4DMap {
    private static final String[] INFECTED = new String[]{"boomer", "charger", "common", "hunter", "jockey", "smoker", "spitter", "tank"};
    private static final String[] ITEMS = new String[]{"adrenaline", "defibs", "medkits", "pills"};
    private HashMap<String, Integer> items;
    private HashMap<String, Integer> kills;
    private boolean played;
    private ArrayList<SteamId> teammates;

    public L4D2Map(XMLData mapData) throws SteamCondenserException {
        String imgUrl = mapData.getString("img");
        this.id = imgUrl.substring(imgUrl.lastIndexOf(47), -4);
        this.name = mapData.getString("name");
        this.played = mapData.getString("hasPlayed").equals("1");
        if (this.played) {
            this.bestTime = mapData.getFloat("besttimemilliseconds").floatValue() / 1000.0f;
            this.items = new HashMap();
            for (String item : ITEMS) {
                this.items.put(item, mapData.getInteger("items_" + item));
            }
            this.kills = new HashMap();
            for (String infected : INFECTED) {
                this.items.put(infected, mapData.getInteger("kills_" + infected));
            }
            this.teammates = new ArrayList();
            for (XMLData teammateData : mapData.getChildren("teammates")) {
                this.teammates.add(SteamId.create(teammateData.getLong(new String[0])));
            }
            String medal = mapData.getString("medal");
            this.medal = medal.equals("gold") ? GOLD : (medal.equals("silver") ? SILVER : (medal.equals("bronze") ? BRONZE : NONE));
        }
    }

    public HashMap<String, Integer> getItems() {
        return this.items;
    }

    public HashMap<String, Integer> getKills() {
        return this.kills;
    }

    public ArrayList<SteamId> getTeammates() {
        return this.teammates;
    }

    public boolean hasPlayed() {
        return this.played;
    }
}

