/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.l4d;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameWeapon;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.l4d.AbstractL4DStats;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4D2Map;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4D2Weapon;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DExplosive;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L4D2Stats
extends AbstractL4DStats {
    private HashMap<String, Object> scavengeStats;
    private HashMap<String, Float> damagePercentages;

    public L4D2Stats(Object steamId) throws SteamCondenserException {
        super(steamId, "l4d2");
        XMLData weaponsData = this.xmlData.getElement("stats", "weapons");
        this.damagePercentages = new HashMap();
        this.damagePercentages.put("melee", weaponsData.getFloat("meleePctDmg"));
        this.damagePercentages.put("pistols", weaponsData.getFloat("pistolsPctDmg"));
        this.damagePercentages.put("rifles", weaponsData.getFloat("bulletsPctDmg"));
        this.damagePercentages.put("shotguns", weaponsData.getFloat("shellsPctDmg"));
    }

    public Map<String, Float> getDamagePercentages() {
        return this.damagePercentages;
    }

    @Override
    public Map<String, Object> getLifetimeStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.lifetimeStats == null) {
            super.getLifetimeStats();
            XMLData lifetimeStatsElement = this.xmlData.getElement("stats", "lifetime");
            this.lifetimeStats.put("avgAdrenalineShared", lifetimeStatsElement.getFloat("adrenalineshared"));
            this.lifetimeStats.put("avgAdrenalineUsed", lifetimeStatsElement.getFloat("adrenalineused"));
            this.lifetimeStats.put("avgDefibrillatorsUsed", lifetimeStatsElement.getFloat("defibrillatorsused"));
        }
        return this.lifetimeStats;
    }

    public Map<String, Object> getScavengeStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.scavengeStats == null) {
            XMLData scavengeStatsElement = this.xmlData.getElement("stats", "scavenge");
            this.scavengeStats = new HashMap();
            this.scavengeStats.put("avgCansPerRound", scavengeStatsElement.getFloat("avgcansperround"));
            this.scavengeStats.put("perfectRounds", scavengeStatsElement.getInteger("perfect16canrounds"));
            this.scavengeStats.put("roundsLost", scavengeStatsElement.getInteger("roundslost"));
            this.scavengeStats.put("roundsPlayed", scavengeStatsElement.getInteger("roundsplayed"));
            this.scavengeStats.put("roundsWon", scavengeStatsElement.getInteger("roundswon"));
            this.scavengeStats.put("totalCans", scavengeStatsElement.getInteger("totalcans"));
            HashMap mapsHash = new HashMap();
            for (XMLData mapData : scavengeStatsElement.getChildren("mapstats")) {
                String mapId = mapData.getString("name");
                HashMap<String, Object> mapHash = new HashMap<String, Object>();
                mapHash.put("avgRoundScore", mapData.getInteger("avgscoreperround"));
                mapHash.put("highestGameScore", mapData.getInteger("highgamescore"));
                mapHash.put("highestRoundScore", mapData.getInteger("highroundscore"));
                mapHash.put("name", mapData.getString("fullname"));
                mapHash.put("roundsPlayed", mapData.getInteger("roundsplayed"));
                mapHash.put("roundsWon", mapData.getInteger("roundswon"));
                mapsHash.put(mapId, mapHash);
            }
            this.scavengeStats.put("maps", mapsHash);
        }
        return this.scavengeStats;
    }

    @Override
    public Map<String, Object> getSurvivalStats() throws SteamCondenserException {
        if (!this.isPublic()) {
            return null;
        }
        if (this.survivalStats == null) {
            super.getSurvivalStats();
            HashMap<String, L4D2Map> mapsHash = new HashMap<String, L4D2Map>();
            for (XMLData mapData : this.xmlData.getChildren("stats", "survival", "maps")) {
                mapsHash.put(mapData.getName(), new L4D2Map(mapData));
            }
            this.survivalStats.put("maps", mapsHash);
        }
        return this.survivalStats;
    }

    public Map<String, GameWeapon> getWeaponStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.weaponStats == null) {
            this.weaponStats = new HashMap();
            for (XMLData weaponData : this.xmlData.getChildren("stats", "weapons")) {
                String weaponName = weaponData.getName();
                GameWeapon weapon = !weaponName.equals("bilejars") && !weaponName.equals("molotov") && !weaponName.equals("pipes") ? new L4D2Weapon(weaponData) : new L4DExplosive(weaponData);
                this.weaponStats.put(weaponName, weapon);
            }
        }
        return this.weaponStats;
    }
}

