/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.l4d;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameWeapon;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.l4d.AbstractL4DStats;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DExplosive;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DMap;
import com.github.koraktor.steamcondenser.steam.community.l4d.L4DWeapon;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L4DStats
extends AbstractL4DStats {
    public L4DStats(Object steamId) throws SteamCondenserException {
        super(steamId, "l4d");
    }

    @Override
    public Map<String, Object> getSurvivalStats() throws SteamCondenserException {
        if (!this.isPublic()) {
            return null;
        }
        if (this.survivalStats == null) {
            super.getSurvivalStats();
            HashMap<String, L4DMap> mapsHash = new HashMap<String, L4DMap>();
            for (XMLData mapData : this.xmlData.getElements("stats", "survival", "maps")) {
                mapsHash.put(mapData.getName(), new L4DMap(mapData));
            }
            this.survivalStats.put("maps", mapsHash);
        }
        return this.survivalStats;
    }

    public Map<String, GameWeapon> getWeaponStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.weaponStats == null) {
            this.weaponStats = new HashMap();
            for (XMLData weaponData : this.xmlData.getChildren("stats", "weapons")) {
                String weaponName = weaponData.getName();
                GameWeapon weapon = !weaponName.equals("molotov") && !weaponName.equals("pipes") ? new L4DWeapon(weaponData) : new L4DExplosive(weaponData);
                this.weaponStats.put(weaponName, weapon);
            }
        }
        return this.weaponStats;
    }
}

