/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.portal2;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameItem;
import com.github.koraktor.steamcondenser.steam.community.portal2.Portal2Inventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Portal2Item
extends GameItem {
    private static final String[] BOTS = new String[]{"pbody", "atlas"};
    private Map<String, Boolean> equipped = new HashMap<String, Boolean>();

    public Portal2Item(Portal2Inventory inventory, JSONObject itemData) throws JSONException, SteamCondenserException {
        super(inventory, itemData);
        for (int botId = 0; botId < BOTS.length; ++botId) {
            this.equipped.put(BOTS[botId], (itemData.getLong("inventory") & (long)(1 << 16 + botId)) != 0L);
        }
    }

    public List<String> getBotsEquipped() {
        ArrayList<String> botsEquipped = new ArrayList<String>();
        for (Map.Entry<String, Boolean> botEquipped : this.equipped.entrySet()) {
            if (!botEquipped.getValue().booleanValue()) continue;
            botsEquipped.add(botEquipped.getKey());
        }
        return botsEquipped;
    }

    public boolean isEquipped() {
        return this.equipped.containsValue(true);
    }
}

